/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.score;

import java.time.LocalDate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.flightcrewscheduling.domain.Employee;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightAssignment;
import org.optaplanner.examples.flightcrewscheduling.domain.Skill;

public class FlightCrewSchedulingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.requiredSkill(constraintFactory), this.flightConflict(constraintFactory), this.transferBetweenTwoFlights(constraintFactory), this.employeeUnavailability(constraintFactory), this.firstAssignmentNotDepartingFromHome(constraintFactory), this.lastAssignmentNotArrivingAtHome(constraintFactory)};
    }

    private Constraint requiredSkill(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(FlightAssignment.class).filter(flightAssignment -> {
            Skill requiredSkill = flightAssignment.getRequiredSkill();
            return !flightAssignment.getEmployee().hasSkill(requiredSkill);
        }).penalize((Score)HardSoftLongScore.ofHard((long)100L)).asConstraint("Required skill");
    }

    private Constraint flightConflict(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachUniquePair(FlightAssignment.class, Joiners.equal(FlightAssignment::getEmployee), Joiners.overlapping(flightAssignment -> flightAssignment.getFlight().getDepartureUTCDateTime(), flightAssignment -> flightAssignment.getFlight().getArrivalUTCDateTime())).penalize((Score)HardSoftLongScore.ofHard((long)10L)).asConstraint("Flight conflict");
    }

    private Constraint transferBetweenTwoFlights(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Employee.class).filter(employee -> employee.countInvalidConnections() > 0L).penalizeLong((Score)HardSoftLongScore.ofHard((long)1L), Employee::countInvalidConnections).asConstraint("Transfer between two flights");
    }

    private Constraint employeeUnavailability(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(FlightAssignment.class).filter(flightAssignment -> {
            LocalDate departureUTCDate = flightAssignment.getFlight().getDepartureUTCDate();
            return !flightAssignment.getEmployee().isAvailable(departureUTCDate);
        }).penalize((Score)HardSoftLongScore.ofHard((long)10L)).asConstraint("Employee unavailable");
    }

    private Constraint firstAssignmentNotDepartingFromHome(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Employee.class).filter(employee -> !employee.isFirstAssignmentDepartingFromHome()).penalize((Score)HardSoftLongScore.ofSoft((long)1000000L)).asConstraint("First assignment not departing from home");
    }

    private Constraint lastAssignmentNotArrivingAtHome(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Employee.class).filter(employee -> !employee.isLastAssignmentArrivingAtHome()).penalize((Score)HardSoftLongScore.ofSoft((long)1000000L)).asConstraint("Last assignment not arriving at home");
    }
}

