/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.core.util.Queue;

public class RuleAgendaItem
implements LinkedListNode<RuleAgendaItem>,
Queue.QueueEntry {
    private transient RuleExecutor executor;
    private RuleAgendaItem previous;
    private RuleAgendaItem next;
    private PathMemory pmem;
    private boolean declarativeAgendaEnabled;
    private int salience;
    private TerminalNode rtn;
    private int index;
    private boolean queued;
    private transient InternalAgendaGroup agendaGroup;

    public RuleAgendaItem() {
    }

    public RuleAgendaItem(int salience, PathMemory pmem, TerminalNode rtn, boolean declarativeAgendaEnabled, InternalAgendaGroup agendaGroup) {
        this.pmem = pmem;
        this.declarativeAgendaEnabled = declarativeAgendaEnabled;
        this.salience = salience;
        this.rtn = rtn;
        this.index = -1;
        this.agendaGroup = agendaGroup;
    }

    public RuleExecutor getRuleExecutor() {
        if (this.executor == null) {
            this.executor = new RuleExecutor(this.pmem, this, this.declarativeAgendaEnabled);
        }
        return this.executor;
    }

    @Override
    public RuleAgendaItem getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(RuleAgendaItem previous) {
        this.previous = previous;
    }

    @Override
    public RuleAgendaItem getNext() {
        return this.next;
    }

    @Override
    public void setNext(RuleAgendaItem next) {
        this.next = next;
    }

    public boolean isInList(LinkedList<RuleAgendaItem> list) {
        return this.previous != null || this.next != null || list.getFirst() == this;
    }

    @Override
    public void nullPrevNext() {
        this.previous = null;
        this.next = null;
    }

    public RuleBasePartitionId getPartition() {
        return this.rtn.getPartitionId();
    }

    public RuleImpl getRule() {
        return this.rtn.getRule();
    }

    public TerminalNode getTerminalNode() {
        return this.rtn;
    }

    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int salience) {
        this.salience = salience;
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(boolean queued) {
        this.queued = queued;
    }

    @Override
    public void setQueueIndex(int index) {
        this.index = index;
    }

    @Override
    public int getQueueIndex() {
        return this.index;
    }

    @Override
    public void dequeue() {
        if (this.agendaGroup != null) {
            this.agendaGroup.remove(this);
        }
        this.queued = false;
    }

    public String toString() {
        return "[Activation rule=" + this.rtn.getRule().getName() + ",  salience=" + this.salience + "]";
    }

    public void remove() {
        this.dequeue();
    }

    public InternalAgendaGroup getAgendaGroup() {
        return this.agendaGroup;
    }

    public boolean isRuleInUse() {
        return this.rtn.getLeftTupleSource() != null;
    }
}

