/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.core.common.InternalFactHandle;

public interface FactHandleLookup {
    public void put(Object var1, InternalFactHandle var2);

    public InternalFactHandle get(Object var1);

    public void clear();

    public static FactHandleLookup create(int arity) {
        switch (arity) {
            case 0: {
                return new Empty();
            }
            case 1: {
                return new Single();
            }
            case 2: {
                return new Double();
            }
        }
        return new Multi();
    }

    public static class Multi
    implements FactHandleLookup {
        private final Map<Object, InternalFactHandle> map = new IdentityHashMap<Object, InternalFactHandle>();

        @Override
        public void put(Object obj, InternalFactHandle fh) {
            this.map.put(obj, fh);
        }

        @Override
        public InternalFactHandle get(Object obj) {
            return this.map.get(obj);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    public static class Double
    implements FactHandleLookup {
        private Object obj1;
        private Object obj2;
        private InternalFactHandle fh1;
        private InternalFactHandle fh2;

        @Override
        public void put(Object obj, InternalFactHandle fh) {
            if (this.obj1 == null) {
                this.obj1 = obj;
                this.fh1 = fh;
            } else {
                this.obj2 = obj;
                this.fh2 = fh;
            }
        }

        @Override
        public InternalFactHandle get(Object obj) {
            return this.obj1 == obj ? this.fh1 : (this.obj2 == obj ? this.fh2 : null);
        }

        @Override
        public void clear() {
            this.obj1 = null;
            this.obj2 = null;
            this.fh1 = null;
            this.fh2 = null;
        }
    }

    public static class Single
    implements FactHandleLookup {
        private Object obj;
        private InternalFactHandle fh;

        @Override
        public void put(Object obj, InternalFactHandle fh) {
            this.obj = obj;
            this.fh = fh;
        }

        @Override
        public InternalFactHandle get(Object obj) {
            return this.obj == obj ? this.fh : null;
        }

        @Override
        public void clear() {
            this.obj = null;
            this.fh = null;
        }
    }

    public static class Empty
    implements FactHandleLookup {
        @Override
        public void put(Object obj, InternalFactHandle fh) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalFactHandle get(Object obj) {
            return null;
        }

        @Override
        public void clear() {
        }
    }
}

