/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.Accumulator;
import org.drools.core.util.index.TupleList;
import org.drools.model.functions.Function1;
import org.drools.model.functions.FunctionN;

public class LambdaGroupByAccumulate
extends Accumulate {
    private Accumulate innerAccumulate;
    private Declaration[] groupingDeclarations;
    private FunctionN groupingFunction;
    private Function1 groupingFunction1;

    public LambdaGroupByAccumulate() {
    }

    public LambdaGroupByAccumulate(Accumulate innerAccumulate, Declaration[] groupingDeclarations, FunctionN groupingFunction) {
        super(innerAccumulate.getSource(), innerAccumulate.getRequiredDeclarations());
        this.innerAccumulate = innerAccumulate;
        this.groupingDeclarations = groupingDeclarations;
        this.groupingFunction = groupingFunction;
        this.groupingFunction1 = groupingDeclarations.length == 1 ? groupingFunction.asFunction1() : null;
    }

    private Object getKey(Tuple tuple, InternalFactHandle handle, ReteEvaluator reteEvaluator) {
        if (this.groupingFunction1 != null) {
            return this.groupingFunction1.apply(this.getValue(tuple, handle, reteEvaluator, this.groupingDeclarations[0]));
        }
        Object[] args = new Object[this.groupingDeclarations.length];
        for (int i = 0; i < this.groupingDeclarations.length; ++i) {
            args[i] = this.getValue(tuple, handle, reteEvaluator, this.groupingDeclarations[i]);
        }
        return this.groupingFunction.apply(args);
    }

    private Object getValue(Tuple tuple, InternalFactHandle handle, ReteEvaluator reteEvaluator, Declaration declaration) {
        return declaration.getValue(reteEvaluator, declaration.getTupleIndex() < tuple.size() ? tuple.get(declaration).getObject() : handle.getObject());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.innerAccumulate = (Accumulate)in.readObject();
        this.groupingDeclarations = (Declaration[])in.readObject();
        this.groupingFunction = (FunctionN)in.readObject();
        this.groupingFunction1 = this.groupingDeclarations.length == 1 ? this.groupingFunction.asFunction1() : null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.innerAccumulate);
        out.writeObject(this.groupingDeclarations);
        out.writeObject(this.groupingFunction);
    }

    public Accumulator[] getAccumulators() {
        return this.innerAccumulate.getAccumulators();
    }

    public Object createFunctionContext() {
        return this.innerAccumulate.createFunctionContext();
    }

    public Object init(Object workingMemoryContext, Object accContext, Object funcContext, Tuple leftTuple, ReteEvaluator reteEvaluator) {
        return funcContext;
    }

    public Object accumulate(Object workingMemoryContext, Object context, Tuple match, InternalFactHandle handle, ReteEvaluator reteEvaluator) {
        AccumulateNode.GroupByContext groupByContext = (AccumulateNode.GroupByContext)context;
        TupleList tupleList = groupByContext.getGroup(workingMemoryContext, this.innerAccumulate, match, this.getKey(match, handle, reteEvaluator), reteEvaluator);
        return this.accumulate(workingMemoryContext, match, handle, groupByContext, (TupleList<AccumulateNode.AccumulateContextEntry>)tupleList, reteEvaluator);
    }

    public Object accumulate(Object workingMemoryContext, Tuple match, InternalFactHandle handle, AccumulateNode.GroupByContext groupByContext, TupleList<AccumulateNode.AccumulateContextEntry> tupleList, ReteEvaluator reteEvaluator) {
        groupByContext.moveToPropagateTupleList(tupleList);
        return this.innerAccumulate.accumulate(workingMemoryContext, tupleList.getContext(), match, handle, reteEvaluator);
    }

    public boolean tryReverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, RightTuple rightParent, LeftTuple match, ReteEvaluator reteEvaluator) {
        TupleList memory = match.getMemory();
        AccumulateNode.AccumulateContextEntry entry = (AccumulateNode.AccumulateContextEntry)memory.getContext();
        boolean reversed = this.innerAccumulate.tryReverse(workingMemoryContext, (Object)entry, leftTuple, handle, rightParent, match, reteEvaluator);
        if (reversed) {
            AccumulateNode.GroupByContext groupByContext = (AccumulateNode.GroupByContext)context;
            groupByContext.moveToPropagateTupleList(match.getMemory());
            memory.remove((Tuple)match);
            if (memory.isEmpty()) {
                groupByContext.removeGroup(entry.getKey());
                ((AccumulateNode.AccumulateContextEntry)memory.getContext()).setEmpty(true);
            }
        }
        return reversed;
    }

    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, ReteEvaluator reteEvaluator) {
        AccumulateNode.AccumulateContextEntry entry = (AccumulateNode.AccumulateContextEntry)context;
        return entry.isEmpty() ? null : this.innerAccumulate.getResult(workingMemoryContext, context, leftTuple, reteEvaluator);
    }

    public boolean supportsReverse() {
        return this.innerAccumulate.supportsReverse();
    }

    public Accumulate clone() {
        return new LambdaGroupByAccumulate(this.innerAccumulate.clone(), this.groupingDeclarations, this.groupingFunction);
    }

    public Object createWorkingMemoryContext() {
        return this.innerAccumulate.createWorkingMemoryContext();
    }

    public boolean isMultiFunction() {
        return this.innerAccumulate.isMultiFunction();
    }

    public void replaceAccumulatorDeclaration(Declaration declaration, Declaration resolved) {
        this.innerAccumulate.replaceAccumulatorDeclaration(declaration, resolved);
    }

    public boolean isGroupBy() {
        return true;
    }
}

