/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Objects;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.list.SubListSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.list.SubListSwapMoveSelectorConfig;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSwapMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.SubListConfigUtil;

public class SubListSwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, SubListSwapMoveSelectorConfig> {
    public SubListSwapMoveSelectorFactory(SubListSwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (!randomSelection) {
            throw new IllegalArgumentException("The subListSwapMoveSelector (" + this.config + ") only supports random selection order.");
        }
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector entitySelector = EntitySelectorFactory.create(new EntitySelectorConfig()).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        SubListSelectorConfig subListSelectorConfig = Objects.requireNonNullElseGet(((SubListSwapMoveSelectorConfig)this.config).getSubListSelectorConfig(), SubListSelectorConfig::new);
        SubListSelectorConfig secondarySubListSelectorConfig = Objects.requireNonNullElse(((SubListSwapMoveSelectorConfig)this.config).getSecondarySubListSelectorConfig(), subListSelectorConfig);
        SubListConfigUtil.transferDeprecatedMinimumSubListSize((SubListSwapMoveSelectorConfig)this.config, SubListSwapMoveSelectorConfig::getMinimumSubListSize, "subListSelector", subListSelectorConfig);
        SubListConfigUtil.transferDeprecatedMaximumSubListSize((SubListSwapMoveSelectorConfig)this.config, SubListSwapMoveSelectorConfig::getMaximumSubListSize, "subListSelector", subListSelectorConfig);
        if (subListSelectorConfig != secondarySubListSelectorConfig) {
            SubListConfigUtil.transferDeprecatedMinimumSubListSize((SubListSwapMoveSelectorConfig)this.config, SubListSwapMoveSelectorConfig::getMinimumSubListSize, "secondarySubListSelector", secondarySubListSelectorConfig);
            SubListConfigUtil.transferDeprecatedMaximumSubListSize((SubListSwapMoveSelectorConfig)this.config, SubListSwapMoveSelectorConfig::getMaximumSubListSize, "secondarySubListSelector", secondarySubListSelectorConfig);
        }
        SubListSelector leftSubListSelector = SubListSelectorFactory.create(subListSelectorConfig).buildSubListSelector(configPolicy, entitySelector, minimumCacheType, selectionOrder);
        SubListSelector rightSubListSelector = SubListSelectorFactory.create(secondarySubListSelectorConfig).buildSubListSelector(configPolicy, entitySelector, minimumCacheType, selectionOrder);
        boolean selectReversingMoveToo = Objects.requireNonNullElse(((SubListSwapMoveSelectorConfig)this.config).getSelectReversingMoveToo(), true);
        return new RandomSubListSwapMoveSelector(leftSubListSelector, rightSubListSelector, selectReversingMoveToo);
    }
}

