/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms.beliefsystem.jtms;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.util.LinkedList;
import org.drools.tms.LogicalDependency;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.jtms.JTMSBeliefSet;
import org.drools.tms.beliefsystem.jtms.JTMSMode;

public class JTMSBeliefSetImpl<M extends JTMSMode<M>>
extends LinkedList<M>
implements JTMSBeliefSet<M> {
    private BeliefSystem<M> beliefSystem;
    private WorkingMemoryAction wmAction;
    private InternalFactHandle rootHandle;
    private int posCounter = 0;
    private int negCounter = 0;

    public JTMSBeliefSetImpl(BeliefSystem<M> beliefSystem, InternalFactHandle rootHandle) {
        this.beliefSystem = beliefSystem;
        this.rootHandle = rootHandle;
    }

    public JTMSBeliefSetImpl() {
    }

    @Override
    public void add(M node) {
        M mode = node;
        String value = ((JTMSMode)mode).getValue();
        boolean neg = MODE.NEGATIVE.getId().equals(value);
        if (neg) {
            super.addLast(node);
            ++this.negCounter;
        } else {
            super.addFirst(node);
            ++this.posCounter;
        }
    }

    @Override
    public void remove(M node) {
        super.remove(node);
        M mode = node;
        String value = ((JTMSMode)mode).getValue();
        boolean neg = MODE.NEGATIVE.getId().equals(value);
        if (neg) {
            --this.negCounter;
        } else {
            --this.posCounter;
        }
    }

    @Override
    public BeliefSystem getBeliefSystem() {
        return this.beliefSystem;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.rootHandle;
    }

    @Override
    public boolean isNegated() {
        return this.posCounter == 0 && this.negCounter > 0;
    }

    @Override
    public boolean isDecided() {
        return !this.isConflicting();
    }

    @Override
    public boolean isConflicting() {
        return this.posCounter > 0 && this.negCounter > 0;
    }

    @Override
    public boolean isPositive() {
        return this.negCounter == 0 && this.posCounter > 0;
    }

    @Override
    public void cancel(PropagationContext context) {
        LogicalDependency node;
        JTMSMode entry = (JTMSMode)this.getFirst();
        while (entry != this.getLast()) {
            JTMSMode temp = (JTMSMode)entry.getNext();
            node = entry.getLogicalDependency();
            node.getJustifier().getLogicalDependencies().remove(node);
            this.remove((M)entry);
            entry = temp;
        }
        JTMSMode last = (JTMSMode)this.getFirst();
        node = last.getLogicalDependency();
        node.getJustifier().getLogicalDependencies().remove(node);
        this.beliefSystem.delete(node, this, context);
    }

    @Override
    public void clear(PropagationContext context) {
        JTMSMode entry = (JTMSMode)this.getFirst();
        while (entry != null) {
            JTMSMode temp = (JTMSMode)entry.getNext();
            LogicalDependency node = entry.getLogicalDependency();
            node.getJustifier().getLogicalDependencies().remove(node);
            this.remove((M)entry);
            entry = temp;
        }
    }

    @Override
    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
        this.wmAction = wmAction;
    }

    public WorkingMemoryAction getWorkingMemoryAction() {
        return this.wmAction;
    }

    public static enum MODE {
        POSITIVE("pos"),
        NEGATIVE("neg");

        private String string;

        private MODE(String string2) {
            this.string = string2;
        }

        public String toExternalForm() {
            return this.string;
        }

        public String toString() {
            return this.string;
        }

        public String getId() {
            return this.string;
        }

        public static MODE resolve(Object id) {
            if (id == null) {
                return null;
            }
            if (NEGATIVE == id || NEGATIVE.getId().equalsIgnoreCase(id.toString())) {
                return NEGATIVE;
            }
            if (POSITIVE == id || POSITIVE.getId().equalsIgnoreCase(id.toString())) {
                return POSITIVE;
            }
            return null;
        }
    }
}

