/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.optional.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;

public class VehicleRoutingIncrementalScoreCalculator
implements IncrementalScoreCalculator<VehicleRoutingSolution, HardSoftLongScore> {
    private boolean timeWindowed;
    private Map<Vehicle, Integer> vehicleDemandMap;
    private long hardScore;
    private long softScore;

    public void resetWorkingSolution(VehicleRoutingSolution solution) {
        this.timeWindowed = solution instanceof TimeWindowedVehicleRoutingSolution;
        this.hardScore = 0L;
        this.softScore = 0L;
        List<Vehicle> vehicleList = solution.getVehicleList();
        this.vehicleDemandMap = new HashMap<Vehicle, Integer>(vehicleList.size());
        for (Vehicle vehicle : vehicleList) {
            int demand = 0;
            List<Customer> customers = vehicle.getCustomers();
            for (int index = 0; index < customers.size(); ++index) {
                Customer customer = customers.get(index);
                demand += customer.getDemand();
                this.softScore -= this.getDistanceFromPreviousStandstill(vehicle, customer, index);
                if (!this.timeWindowed) continue;
                this.insertArrivalTime((TimeWindowedCustomer)customer);
            }
            if (customers.size() > 0) {
                this.softScore -= this.getDistanceToDepot(vehicle, customers.size() - 1);
            }
            this.vehicleDemandMap.put(vehicle, demand);
            this.hardScore += (long)Math.min(vehicle.getCapacity() - demand, 0);
        }
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        if (variableName.equals("arrivalTime")) {
            this.retractArrivalTime((TimeWindowedCustomer)entity);
        }
    }

    public void afterVariableChanged(Object entity, String variableName) {
        if (variableName.equals("arrivalTime")) {
            this.insertArrivalTime((TimeWindowedCustomer)entity);
        }
    }

    public void beforeListVariableChanged(Object entity, String variableName, int fromIndex, int toIndex) {
        Vehicle vehicle = (Vehicle)entity;
        for (int index = fromIndex; index < toIndex; ++index) {
            Customer customer = vehicle.getCustomers().get(index);
            int capacity = vehicle.getCapacity();
            int oldDemand = this.vehicleDemandMap.get(vehicle);
            int newDemand = oldDemand - customer.getDemand();
            this.hardScore += (long)(Math.min(capacity - newDemand, 0) - Math.min(capacity - oldDemand, 0));
            this.vehicleDemandMap.put(vehicle, newDemand);
            this.softScore += this.getDistanceFromPreviousStandstill(vehicle, customer, index);
        }
        if (toIndex < vehicle.getCustomers().size()) {
            this.softScore += this.getDistanceFromPreviousStandstill(vehicle, toIndex);
        } else if (toIndex > 0) {
            this.softScore += this.getDistanceToDepot(vehicle, toIndex - 1);
        }
    }

    public void afterListVariableChanged(Object entity, String variableName, int fromIndex, int toIndex) {
        Vehicle vehicle = (Vehicle)entity;
        for (int index = fromIndex; index < toIndex; ++index) {
            Customer customer = vehicle.getCustomers().get(index);
            int capacity = vehicle.getCapacity();
            int oldDemand = this.vehicleDemandMap.get(vehicle);
            int newDemand = oldDemand + customer.getDemand();
            this.hardScore += (long)(Math.min(capacity - newDemand, 0) - Math.min(capacity - oldDemand, 0));
            this.vehicleDemandMap.put(vehicle, newDemand);
            this.softScore -= this.getDistanceFromPreviousStandstill(vehicle, customer, index);
        }
        if (toIndex < vehicle.getCustomers().size()) {
            this.softScore -= this.getDistanceFromPreviousStandstill(vehicle, toIndex);
        } else if (toIndex > 0) {
            this.softScore -= this.getDistanceToDepot(vehicle, toIndex - 1);
        }
    }

    private long getDistanceToDepot(Vehicle vehicle, int index) {
        return this.getDistanceToDepot(vehicle, vehicle.getCustomers().get(index), index);
    }

    private long getDistanceToDepot(Vehicle vehicle, Customer customer, int index) {
        if (index == vehicle.getCustomers().size() - 1) {
            return customer.getLocation().getDistanceTo(vehicle.getLocation());
        }
        return 0L;
    }

    private long getDistanceFromPreviousStandstill(Vehicle vehicle, int index) {
        return this.getDistanceFromPreviousStandstill(vehicle, vehicle.getCustomers().get(index), index);
    }

    private long getDistanceFromPreviousStandstill(Vehicle vehicle, Customer customer, int index) {
        if (index == 0) {
            return vehicle.getLocation().getDistanceTo(customer.getLocation());
        }
        return vehicle.getCustomers().get(index - 1).getLocation().getDistanceTo(customer.getLocation());
    }

    private void insertArrivalTime(TimeWindowedCustomer customer) {
        long dueTime;
        Long arrivalTime = customer.getArrivalTime();
        if (arrivalTime != null && (dueTime = customer.getDueTime()) < arrivalTime) {
            this.hardScore -= arrivalTime - dueTime;
        }
    }

    private void retractArrivalTime(TimeWindowedCustomer customer) {
        long dueTime;
        Long arrivalTime = customer.getArrivalTime();
        if (arrivalTime != null && (dueTime = customer.getDueTime()) < arrivalTime) {
            this.hardScore += arrivalTime - dueTime;
        }
    }

    public HardSoftLongScore calculateScore() {
        return HardSoftLongScore.of((long)this.hardScore, (long)this.softScore);
    }

    public void beforeEntityAdded(Object entity) {
        throw new UnsupportedOperationException("The VRP example does not support adding vehicles.");
    }

    public void afterEntityAdded(Object entity) {
        throw new UnsupportedOperationException("The VRP example does not support adding vehicles.");
    }

    public void beforeEntityRemoved(Object entity) {
        throw new UnsupportedOperationException("The VRP example does not support removing vehicles.");
    }

    public void afterEntityRemoved(Object entity) {
        throw new UnsupportedOperationException("The VRP example does not support removing vehicles.");
    }
}

