/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingSolutionFileIO;

public class VehicleRoutingImporter
extends AbstractTxtSolutionImporter<VehicleRoutingSolution> {
    public static void main(String[] args) {
        SolutionConverter<VehicleRoutingSolution> converter = SolutionConverter.createImportConverter("vehiclerouting", new VehicleRoutingImporter(), new VehicleRoutingSolutionFileIO());
        converter.convert("vrpweb/basic/air/A-n33-k6.vrp", "cvrp-32customers.json");
        converter.convert("vrpweb/basic/air/A-n55-k9.vrp", "cvrp-54customers.json");
        converter.convert("vrpweb/basic/air/F-n72-k4.vrp", "cvrp-72customers.json");
        converter.convert("vrpweb/timewindowed/air/Solomon_025_C101.vrp", "cvrptw-25customers.json");
        converter.convert("vrpweb/timewindowed/air/Solomon_100_R101.vrp", "cvrptw-100customers-A.json");
        converter.convert("vrpweb/timewindowed/air/Solomon_100_R201.vrp", "cvrptw-100customers-B.json");
        converter.convert("vrpweb/timewindowed/air/Homberger_0400_R1_4_1.vrp", "cvrptw-400customers.json");
        converter.convert("vrpweb/basic/road-unknown/bays-n29-k5.vrp", "road-cvrp-29customers.json");
    }

    @Override
    public String getInputFileSuffix() {
        return "vrp";
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder<VehicleRoutingSolution> createTxtInputBuilder() {
        return new VehicleRoutingInputBuilder();
    }

    public static class VehicleRoutingInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder<VehicleRoutingSolution> {
        private VehicleRoutingSolution solution;
        private boolean timewindowed;
        private int customerListSize;
        private int vehicleListSize;
        private int capacity;
        private Map<Long, Location> locationMap;
        private List<Depot> depotList;

        @Override
        public VehicleRoutingSolution readSolution() throws IOException {
            String firstLine = this.readStringValue();
            if (firstLine.matches("\\s*NAME\\s*:.*")) {
                this.solution = new VehicleRoutingSolution();
                this.solution.setName(this.removePrefixSuffixFromLine(firstLine, "\\s*NAME\\s*:", ""));
                this.readVrpWebFormat();
            } else if (this.splitBySpacesOrTabs(firstLine).length == 3) {
                this.timewindowed = false;
                this.solution = new VehicleRoutingSolution();
                this.solution.setName(SolutionBusiness.getBaseFileName(this.inputFile));
                String[] tokens = this.splitBySpacesOrTabs(firstLine, 3);
                this.customerListSize = Integer.parseInt(tokens[0]);
                this.vehicleListSize = Integer.parseInt(tokens[1]);
                this.capacity = Integer.parseInt(tokens[2]);
                this.readCourseraFormat();
            } else {
                this.timewindowed = true;
                this.solution = new TimeWindowedVehicleRoutingSolution();
                this.solution.setName(firstLine);
                this.readTimeWindowedFormat();
            }
            BigInteger a = AbstractSolutionImporter.factorial(this.customerListSize + this.vehicleListSize - 1);
            BigInteger b = AbstractSolutionImporter.factorial(this.vehicleListSize - 1);
            BigInteger possibleSolutionSize = a == null || b == null ? null : a.divide(b);
            this.logger.info("VehicleRoutingSolution {} has {} depots, {} vehicles and {} customers with a search space of {}.", new Object[]{this.getInputId(), this.solution.getDepotList().size(), this.solution.getVehicleList().size(), this.solution.getCustomerList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.solution;
        }

        public void readVrpWebFormat() throws IOException {
            this.readVrpWebHeaders();
            this.readVrpWebLocationList();
            this.readVrpWebCustomerList();
            this.readVrpWebDepotList();
            this.createVrpWebVehicleList();
            this.readConstantLine("EOF");
        }

        private void readVrpWebHeaders() throws IOException {
            String vrpType;
            this.skipOptionalConstantLines("COMMENT *:.*");
            switch (vrpType = this.readStringValue("TYPE *:")) {
                case "CVRP": {
                    this.timewindowed = false;
                    break;
                }
                case "CVRPTW": {
                    this.timewindowed = true;
                    Long solutionId = this.solution.getId();
                    String solutionName = this.solution.getName();
                    this.solution = new TimeWindowedVehicleRoutingSolution(solutionId);
                    this.solution.setName(solutionName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The vrpType (" + vrpType + ") is not supported.");
                }
            }
            this.customerListSize = this.readIntegerValue("DIMENSION *:");
            String edgeWeightType = this.readStringValue("EDGE_WEIGHT_TYPE *:");
            if (edgeWeightType.equalsIgnoreCase("EUC_2D")) {
                this.solution.setDistanceType(DistanceType.AIR_DISTANCE);
            } else if (edgeWeightType.equalsIgnoreCase("EXPLICIT")) {
                this.solution.setDistanceType(DistanceType.ROAD_DISTANCE);
                String edgeWeightFormat = this.readStringValue("EDGE_WEIGHT_FORMAT *:");
                if (!edgeWeightFormat.equalsIgnoreCase("FULL_MATRIX")) {
                    throw new IllegalArgumentException("The edgeWeightFormat (" + edgeWeightFormat + ") is not supported.");
                }
            } else if (edgeWeightType.equalsIgnoreCase("SEGMENTED_EXPLICIT")) {
                this.solution.setDistanceType(DistanceType.SEGMENTED_ROAD_DISTANCE);
                String edgeWeightFormat = this.readStringValue("EDGE_WEIGHT_FORMAT *:");
                if (!edgeWeightFormat.equalsIgnoreCase("HUB_AND_NEARBY_MATRIX")) {
                    throw new IllegalArgumentException("The edgeWeightFormat (" + edgeWeightFormat + ") is not supported.");
                }
            } else {
                throw new IllegalArgumentException("The edgeWeightType (" + edgeWeightType + ") is not supported.");
            }
            this.solution.setDistanceUnitOfMeasurement(this.readOptionalStringValue("EDGE_WEIGHT_UNIT_OF_MEASUREMENT *:", "distance"));
            this.capacity = this.readIntegerValue("CAPACITY *:");
        }

        private void readVrpWebLocationList() throws IOException {
            ArrayList<Location> locationList;
            String[] lineTokens;
            String line;
            int i;
            DistanceType distanceType = this.solution.getDistanceType();
            ArrayList<HubSegmentLocation> hubLocationList = null;
            this.locationMap = new LinkedHashMap<Long, Location>(this.customerListSize);
            if (distanceType == DistanceType.SEGMENTED_ROAD_DISTANCE) {
                int hubListSize = this.readIntegerValue("HUBS *:");
                hubLocationList = new ArrayList<HubSegmentLocation>(hubListSize);
                this.readConstantLine("HUB_COORD_SECTION");
                for (i = 0; i < hubListSize; ++i) {
                    line = this.bufferedReader.readLine();
                    lineTokens = this.splitBySpacesOrTabs(line.trim(), 3, 4);
                    HubSegmentLocation location = new HubSegmentLocation(Long.parseLong(lineTokens[0]), Double.parseDouble(lineTokens[1]), Double.parseDouble(lineTokens[2]));
                    if (lineTokens.length >= 4) {
                        location.setName(lineTokens[3]);
                    }
                    hubLocationList.add(location);
                    this.locationMap.put(location.getId(), location);
                }
            }
            ArrayList<Location> customerLocationList = new ArrayList<Location>(this.customerListSize);
            this.readConstantLine("NODE_COORD_SECTION");
            for (i = 0; i < this.customerListSize; ++i) {
                Location location;
                line = this.bufferedReader.readLine();
                lineTokens = this.splitBySpacesOrTabs(line.trim(), 3, 4);
                long id = Long.parseLong(lineTokens[0]);
                double latitude = Double.parseDouble(lineTokens[1]);
                double longitude = Double.parseDouble(lineTokens[2]);
                switch (distanceType) {
                    case AIR_DISTANCE: {
                        location = new AirLocation(id, latitude, longitude);
                        break;
                    }
                    case ROAD_DISTANCE: {
                        location = new RoadLocation(id, latitude, longitude);
                        break;
                    }
                    case SEGMENTED_ROAD_DISTANCE: {
                        location = new RoadSegmentLocation(id, latitude, longitude);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The distanceType (" + distanceType + ") is not implemented.");
                    }
                }
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                customerLocationList.add(location);
                this.locationMap.put(location.getId(), location);
            }
            if (distanceType == DistanceType.ROAD_DISTANCE) {
                this.readConstantLine("EDGE_WEIGHT_SECTION");
                for (i = 0; i < this.customerListSize; ++i) {
                    RoadLocation location = (RoadLocation)customerLocationList.get(i);
                    LinkedHashMap<RoadLocation, Double> travelDistanceMap = new LinkedHashMap<RoadLocation, Double>(this.customerListSize);
                    String line2 = this.bufferedReader.readLine();
                    String[] lineTokens2 = this.splitBySpacesOrTabs(line2.trim(), this.customerListSize);
                    for (int j = 0; j < this.customerListSize; ++j) {
                        double travelDistance = Double.parseDouble(lineTokens2[j]);
                        if (i == j) {
                            if (travelDistance == 0.0) continue;
                            throw new IllegalStateException("The travelDistance (" + travelDistance + ") should be zero.");
                        }
                        RoadLocation otherLocation = (RoadLocation)customerLocationList.get(j);
                        travelDistanceMap.put(otherLocation, travelDistance);
                    }
                    location.setTravelDistanceMap(travelDistanceMap);
                }
            }
            if (distanceType == DistanceType.SEGMENTED_ROAD_DISTANCE) {
                this.readConstantLine("SEGMENTED_EDGE_WEIGHT_SECTION");
                int locationListSize = hubLocationList.size() + this.customerListSize;
                for (int i2 = 0; i2 < locationListSize; ++i2) {
                    String line3 = this.bufferedReader.readLine();
                    String[] lineTokens3 = this.splitBySpacesOrTabs(line3.trim(), 3, null);
                    if (lineTokens3.length % 2 != 1) {
                        throw new IllegalArgumentException("Invalid SEGMENTED_EDGE_WEIGHT_SECTION line (" + line3 + ").");
                    }
                    long id = Long.parseLong(lineTokens3[0]);
                    Location location = this.locationMap.get(id);
                    if (location == null) {
                        throw new IllegalArgumentException("The location with id (" + id + ") of line (" + line3 + ") does not exist.");
                    }
                    LinkedHashMap<HubSegmentLocation, Double> hubTravelDistanceMap = new LinkedHashMap<HubSegmentLocation, Double>(lineTokens3.length / 2);
                    LinkedHashMap<RoadSegmentLocation, Double> nearbyTravelDistanceMap = new LinkedHashMap<RoadSegmentLocation, Double>(lineTokens3.length / 2);
                    for (int j = 1; j < lineTokens3.length; j += 2) {
                        Location otherLocation = this.locationMap.get(Long.parseLong(lineTokens3[j]));
                        double travelDistance = Double.parseDouble(lineTokens3[j + 1]);
                        if (otherLocation instanceof HubSegmentLocation) {
                            hubTravelDistanceMap.put((HubSegmentLocation)otherLocation, travelDistance);
                            continue;
                        }
                        nearbyTravelDistanceMap.put((RoadSegmentLocation)otherLocation, travelDistance);
                    }
                    if (location instanceof HubSegmentLocation) {
                        HubSegmentLocation hubSegmentLocation = (HubSegmentLocation)location;
                        hubSegmentLocation.setHubTravelDistanceMap(hubTravelDistanceMap);
                        hubSegmentLocation.setNearbyTravelDistanceMap(nearbyTravelDistanceMap);
                        continue;
                    }
                    RoadSegmentLocation roadSegmentLocation = (RoadSegmentLocation)location;
                    roadSegmentLocation.setHubTravelDistanceMap(hubTravelDistanceMap);
                    roadSegmentLocation.setNearbyTravelDistanceMap(nearbyTravelDistanceMap);
                }
            }
            if (distanceType == DistanceType.SEGMENTED_ROAD_DISTANCE) {
                locationList = new ArrayList(hubLocationList.size() + this.customerListSize);
                locationList.addAll(hubLocationList);
                locationList.addAll(customerLocationList);
            } else {
                locationList = customerLocationList;
            }
            this.solution.setLocationList(locationList);
        }

        private void readVrpWebCustomerList() throws IOException {
            this.readConstantLine("DEMAND_SECTION");
            this.depotList = new ArrayList<Depot>(this.customerListSize);
            ArrayList<Customer> customerList = new ArrayList<Customer>(this.customerListSize);
            for (int i = 0; i < this.customerListSize; ++i) {
                Location location;
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), this.timewindowed ? 5 : 2);
                long id = Long.parseLong(lineTokens[0]);
                int demand = Integer.parseInt(lineTokens[1]);
                if (demand == 0) {
                    location = this.locationMap.get(id);
                    if (location == null) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has no location (" + location + ").");
                    }
                    if (this.timewindowed) {
                        long serviceDuration = Long.parseLong(lineTokens[4]);
                        if (serviceDuration != 0L) {
                            throw new IllegalArgumentException("The depot with id (" + id + ") has a serviceDuration (" + serviceDuration + ") that is not 0.");
                        }
                        this.depotList.add(new TimeWindowedDepot(id, location, Long.parseLong(lineTokens[2]), Long.parseLong(lineTokens[3])));
                        continue;
                    }
                    this.depotList.add(new Depot(id, location));
                    continue;
                }
                location = this.locationMap.get(id);
                if (location == null) {
                    throw new IllegalArgumentException("The customer with id (" + id + ") has no location (" + location + ").");
                }
                if (this.timewindowed) {
                    customerList.add(new TimeWindowedCustomer(id, location, demand, Long.parseLong(lineTokens[2]), Long.parseLong(lineTokens[3]), Long.parseLong(lineTokens[4])));
                    continue;
                }
                customerList.add(new Customer(id, location, demand));
            }
            this.solution.setCustomerList(customerList);
            this.solution.setDepotList(this.depotList);
        }

        private void readVrpWebDepotList() throws IOException {
            this.readConstantLine("DEPOT_SECTION");
            int depotCount = 0;
            long id = this.readLongValue();
            while (id != -1L) {
                ++depotCount;
                id = this.readLongValue();
            }
            if (depotCount != this.depotList.size()) {
                throw new IllegalStateException("The number of demands with 0 demand (" + this.depotList.size() + ") differs from the number of depots (" + depotCount + ").");
            }
        }

        private void createVrpWebVehicleList() throws IOException {
            String inputFileName = this.inputFile.getName();
            if (inputFileName.toLowerCase().startsWith("tutorial")) {
                this.vehicleListSize = this.readIntegerValue("VEHICLES *:");
            } else {
                String inputFileNameRegex = "^.+\\-k(\\d+)\\.vrp$";
                if (!inputFileName.matches(inputFileNameRegex)) {
                    throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") does not match the inputFileNameRegex (" + inputFileNameRegex + ").");
                }
                String vehicleListSizeString = inputFileName.replaceAll(inputFileNameRegex, "$1");
                try {
                    this.vehicleListSize = Integer.parseInt(vehicleListSizeString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") has a vehicleListSizeString (" + vehicleListSizeString + ") that is not a number.", e);
                }
            }
            this.createVehicleList();
        }

        private void createVehicleList() {
            ArrayList<Vehicle> vehicleList = new ArrayList<Vehicle>(this.vehicleListSize);
            long id = 0L;
            for (int i = 0; i < this.vehicleListSize; ++i) {
                Vehicle vehicle = new Vehicle(i, this.capacity, this.depotList.get(i % this.depotList.size()));
                vehicleList.add(vehicle);
            }
            this.solution.setVehicleList(vehicleList);
        }

        public void readCourseraFormat() throws IOException {
            this.solution.setDistanceType(DistanceType.AIR_DISTANCE);
            this.solution.setDistanceUnitOfMeasurement("distance");
            ArrayList<Location> locationList = new ArrayList<Location>(this.customerListSize);
            this.depotList = new ArrayList<Depot>(1);
            ArrayList<Customer> customerList = new ArrayList<Customer>(this.customerListSize);
            this.locationMap = new LinkedHashMap<Long, Location>(this.customerListSize);
            for (int i = 0; i < this.customerListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 3, 4);
                AirLocation location = new AirLocation(i, Double.parseDouble(lineTokens[1]), Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                locationList.add(location);
                if (i == 0) {
                    Depot depot = new Depot(i, location);
                    this.depotList.add(depot);
                    continue;
                }
                int demand = Integer.parseInt(lineTokens[0]);
                if (demand == 0) continue;
                Customer customer = new Customer(i, location, demand);
                customerList.add(customer);
            }
            this.solution.setLocationList(locationList);
            this.solution.setDepotList(this.depotList);
            this.solution.setCustomerList(customerList);
            this.createVehicleList();
        }

        public void readTimeWindowedFormat() throws IOException {
            this.readTimeWindowedHeaders();
            this.readTimeWindowedDepotAndCustomers();
            this.createVehicleList();
        }

        private void readTimeWindowedHeaders() throws IOException {
            this.solution.setDistanceType(DistanceType.AIR_DISTANCE);
            this.solution.setDistanceUnitOfMeasurement("distance");
            this.readEmptyLine();
            this.readConstantLine("VEHICLE");
            this.readConstantLine("NUMBER +CAPACITY");
            String[] lineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 2);
            this.vehicleListSize = Integer.parseInt(lineTokens[0]);
            this.capacity = Integer.parseInt(lineTokens[1]);
            this.readEmptyLine();
            this.readConstantLine("CUSTOMER");
            this.readConstantLine("CUST\\s+NO\\.\\s+XCOORD\\.\\s+YCOORD\\.\\s+DEMAND\\s+READY\\s+TIME\\s+DUE\\s+DATE\\s+SERVICE\\s+TIME");
            this.readEmptyLine();
        }

        private void readTimeWindowedDepotAndCustomers() throws IOException {
            String line = this.bufferedReader.readLine();
            int locationListSizeEstimation = 25;
            ArrayList<Location> locationList = new ArrayList<Location>(locationListSizeEstimation);
            this.depotList = new ArrayList<Depot>(1);
            TimeWindowedDepot depot = null;
            ArrayList<Customer> customerList = new ArrayList<Customer>(locationListSizeEstimation);
            boolean first = true;
            while (line != null && !line.trim().isEmpty()) {
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 7);
                long id = Long.parseLong(lineTokens[0]);
                AirLocation location = new AirLocation(id, Double.parseDouble(lineTokens[1]), Double.parseDouble(lineTokens[2]));
                locationList.add(location);
                int demand = Integer.parseInt(lineTokens[3]);
                long readyTime = Long.parseLong(lineTokens[4]) * 1000L;
                long dueTime = Long.parseLong(lineTokens[5]) * 1000L;
                long serviceDuration = Long.parseLong(lineTokens[6]) * 1000L;
                if (first) {
                    if (demand != 0) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has a demand (" + demand + ").");
                    }
                    if (serviceDuration != 0L) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has a serviceDuration (" + serviceDuration + ").");
                    }
                    depot = new TimeWindowedDepot(id, location, readyTime, dueTime);
                    this.depotList.add(depot);
                    first = false;
                } else {
                    long maximumDueTime = depot.getDueTime() - serviceDuration - location.getDistanceTo(depot.getLocation());
                    if (dueTime > maximumDueTime) {
                        this.logger.warn("The customer ({})'s dueTime ({}) was automatically reduced to maximumDueTime ({}) because of the depot's dueTime ({}).", new Object[]{id, dueTime, maximumDueTime, depot.getDueTime()});
                        dueTime = maximumDueTime;
                    }
                    if (demand != 0) {
                        TimeWindowedCustomer customer = new TimeWindowedCustomer(id, location, demand, readyTime, dueTime, serviceDuration);
                        customerList.add(customer);
                    }
                }
                line = this.bufferedReader.readLine();
            }
            this.solution.setLocationList(locationList);
            this.solution.setDepotList(this.depotList);
            this.solution.setCustomerList(customerList);
            this.customerListSize = locationList.size();
        }
    }
}

