/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;

public class ListUtils {
    public static <T> List<List<T>> partition(List<T> list, int size) {
        Objects.requireNonNull(list, "list");
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than 0");
        }
        return new Partition<T>(list, size);
    }

    private static class Partition<T>
    extends AbstractList<List<T>> {
        private final List<T> list;
        private final int size;

        private Partition(List<T> list, int size) {
            this.list = list;
            this.size = size;
        }

        @Override
        public List<T> get(int index) {
            int listSize = this.size();
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index " + index + " must not be negative");
            }
            if (index >= listSize) {
                throw new IndexOutOfBoundsException("Index " + index + " must be less than size " + listSize);
            }
            int start = index * this.size;
            int end = Math.min(start + this.size, this.list.size());
            return this.list.subList(start, end);
        }

        @Override
        public int size() {
            return (int)Math.ceil((double)this.list.size() / (double)this.size);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }
}

