/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import java.util.ArrayList;
import java.util.List;
import org.drools.ancompiler.AbstractCompilerHandler;
import org.drools.ancompiler.ListUtils;
import org.drools.base.common.NetworkNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.Sink;

public class SetNodeReferenceHandler {
    private static final String PARAM_TYPE = NetworkNode.class.getName();
    private static final String METHOD_NAME = "setNetworkNodeReference";
    private static final String PARAM_NAME = "node";
    private static final String switchStatementCall = "         {   boolean setNetworkResultN = setNetworkNodeN(node);\n        if(setNetworkResultN) {\n            return;\n        }}";
    private final List<NetworkNode> nodes;

    public SetNodeReferenceHandler(List<NetworkNode> nodes) {
        this.nodes = nodes;
    }

    public void emitCode(StringBuilder builder) {
        ArrayList<MethodDeclaration> allMethods = new ArrayList<MethodDeclaration>();
        MethodDeclaration methodDeclaration = new MethodDeclaration(NodeList.nodeList((Node[])new Modifier[]{Modifier.protectedModifier()}), METHOD_NAME, (Type)new VoidType(), this.nodeParameter());
        allMethods.add(methodDeclaration);
        BlockStmt setNetworkNodeReference = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new RuntimeException("No block statement"));
        List<List<NetworkNode>> partitionedNodes = ListUtils.partition(this.nodes, 20);
        for (int i = 0; i < partitionedNodes.size(); ++i) {
            List<NetworkNode> subNodes = partitionedNodes.get(i);
            MethodDeclaration m = this.generateSwitchForSubNodes(i, subNodes, setNetworkNodeReference);
            allMethods.add(m);
        }
        for (MethodDeclaration md : allMethods) {
            builder.append(md.toString());
            builder.append("\n");
        }
    }

    private NodeList<Parameter> nodeParameter() {
        return NodeList.nodeList((Node[])new Parameter[]{new Parameter(StaticJavaParser.parseType((String)PARAM_TYPE), PARAM_NAME)});
    }

    private MethodDeclaration generateSwitchForSubNodes(int partitionIndex, List<NetworkNode> subNodes, BlockStmt setNetworkNodeReferenceBody) {
        String switchMethodName = "setNetworkNode" + partitionIndex;
        BlockStmt callSwitchStatements = StaticJavaParser.parseBlock((String)switchStatementCall);
        callSwitchStatements.findAll(SimpleName.class, ne -> ne.toString().equals("setNetworkResultN")).forEach(n -> n.replace((Node)new SimpleName("setNetworkResult" + partitionIndex)));
        callSwitchStatements.findAll(MethodCallExpr.class, mc -> mc.getNameAsString().equals("setNetworkNodeN")).forEach(n -> n.setName(new SimpleName("setNetworkNode" + partitionIndex)));
        callSwitchStatements.getStatements().forEach(arg_0 -> ((BlockStmt)setNetworkNodeReferenceBody).addStatement(arg_0));
        MethodDeclaration switchMethod = new MethodDeclaration(NodeList.nodeList((Node[])new Modifier[]{Modifier.privateModifier()}), switchMethodName, (Type)PrimitiveType.booleanType(), this.nodeParameter());
        BlockStmt switchBodyStatements = (BlockStmt)switchMethod.getBody().orElseThrow(() -> new RuntimeException("No"));
        this.generateSwitchBody(switchBodyStatements, subNodes);
        return switchMethod;
    }

    private void generateSwitchBody(BlockStmt switchBodyStatements, List<NetworkNode> subNodes) {
        SwitchStmt switchStmt = new SwitchStmt();
        switchStmt.setSelector(StaticJavaParser.parseExpression((String)"node.getId()"));
        NodeList entries = new NodeList();
        for (NetworkNode n : subNodes) {
            String assignStatementString = n instanceof AlphaNode ? SetNodeReferenceHandler.getVariableAssignmentStatementAlphaNode((AlphaNode)n) : SetNodeReferenceHandler.getVariableAssignmentStatement(n);
            Statement assignStmt = StaticJavaParser.parseStatement((String)assignStatementString);
            SwitchEntry se = new SwitchEntry(NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(n.getId())}), SwitchEntry.Type.STATEMENT_GROUP, NodeList.nodeList((Node[])new Statement[]{assignStmt, new ReturnStmt((Expression)new BooleanLiteralExpr(true))}));
            entries.add((Node)se);
        }
        switchStmt.setEntries(entries);
        switchBodyStatements.addStatement((Statement)switchStmt);
        switchBodyStatements.addStatement((Statement)new ReturnStmt((Expression)new BooleanLiteralExpr(false)));
    }

    private static String getVariableAssignmentStatement(NetworkNode sink) {
        Class<?> variableType = AbstractCompilerHandler.getVariableType((Sink)sink);
        String assignmentStatement = AbstractCompilerHandler.getVariableName((Sink)sink) + " = (" + variableType.getCanonicalName() + ")node;";
        return assignmentStatement;
    }

    private static String getVariableAssignmentStatementAlphaNode(AlphaNode alphaNode) {
        Class<?> variableType = AbstractCompilerHandler.getVariableType(alphaNode);
        String assignmentStatement = AbstractCompilerHandler.getVariableName(alphaNode) + " = (" + variableType.getName() + ") ((" + AlphaNode.class.getName() + ")node).getConstraint();";
        return assignmentStatement;
    }
}

