/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.partitionedsearch.PartitionedSearchPhaseConfig;
import org.optaplanner.core.config.phase.NoChangePhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.phase.custom.CustomPhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.monitoring.MonitoringConfig;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.config.solver.random.RandomType;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.io.OptaPlannerXmlSerializationException;
import org.optaplanner.core.impl.io.jaxb.SolverConfigIO;
import org.optaplanner.core.impl.solver.random.RandomFactory;

@XmlRootElement(name="solver")
@XmlType(name="solverConfig", propOrder={"environmentMode", "daemon", "randomType", "randomSeed", "randomFactoryClass", "moveThreadCount", "moveThreadBufferSize", "threadFactoryClass", "monitoringConfig", "solutionClass", "entityClassList", "domainAccessType", "scoreDirectorFactoryConfig", "terminationConfig", "phaseConfigList"})
public class SolverConfig
extends AbstractConfig<SolverConfig> {
    public static final String XML_ELEMENT_NAME = "solver";
    public static final String XML_NAMESPACE = "https://www.optaplanner.org/xsd/solver";
    public static final String XML_TYPE_NAME = "solverConfig";
    public static final String MOVE_THREAD_COUNT_NONE = "NONE";
    public static final String MOVE_THREAD_COUNT_AUTO = "AUTO";
    @XmlTransient
    private ClassLoader classLoader = null;
    protected EnvironmentMode environmentMode = null;
    protected Boolean daemon = null;
    protected RandomType randomType = null;
    protected Long randomSeed = null;
    protected Class<? extends RandomFactory> randomFactoryClass = null;
    protected String moveThreadCount = null;
    protected Integer moveThreadBufferSize = null;
    protected Class<? extends ThreadFactory> threadFactoryClass = null;
    protected Class<?> solutionClass = null;
    @XmlElement(name="entityClass")
    protected List<Class<?>> entityClassList = null;
    protected DomainAccessType domainAccessType = null;
    @XmlTransient
    protected Map<String, MemberAccessor> gizmoMemberAccessorMap = null;
    @XmlTransient
    protected Map<String, SolutionCloner> gizmoSolutionClonerMap = null;
    @XmlElement(name="scoreDirectorFactory")
    protected ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = null;
    @XmlElement(name="termination")
    private TerminationConfig terminationConfig;
    @XmlElements(value={@XmlElement(name="constructionHeuristic", type=ConstructionHeuristicPhaseConfig.class), @XmlElement(name="customPhase", type=CustomPhaseConfig.class), @XmlElement(name="exhaustiveSearch", type=ExhaustiveSearchPhaseConfig.class), @XmlElement(name="localSearch", type=LocalSearchPhaseConfig.class), @XmlElement(name="noChangePhase", type=NoChangePhaseConfig.class), @XmlElement(name="partitionedSearch", type=PartitionedSearchPhaseConfig.class)})
    protected List<PhaseConfig> phaseConfigList = null;
    @XmlElement(name="monitoring")
    protected MonitoringConfig monitoringConfig = null;

    public static SolverConfig createFromXmlResource(String solverConfigResource) {
        return SolverConfig.createFromXmlResource(solverConfigResource, null);
    }

    public static SolverConfig createFromXmlResource(String solverConfigResource, ClassLoader classLoader) {
        SolverConfig solverConfig;
        block11: {
            ClassLoader actualClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            InputStream in = actualClassLoader.getResourceAsStream(solverConfigResource);
            try {
                if (in == null) {
                    String errorMessage = "The solverConfigResource (" + solverConfigResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                    if (solverConfigResource.startsWith("/")) {
                        errorMessage = errorMessage + "\nA classpath resource should not start with a slash (/). A solverConfigResource adheres to ClassLoader.getResource(String). Maybe remove the leading slash from the solverConfigResource.";
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                solverConfig = SolverConfig.createFromXmlInputStream(in, classLoader);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OptaPlannerXmlSerializationException e) {
                    throw new IllegalArgumentException("Unmarshalling of solverConfigResource (" + solverConfigResource + ") fails.", e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Reading the solverConfigResource (" + solverConfigResource + ") fails.", e);
                }
            }
            in.close();
        }
        return solverConfig;
    }

    public static SolverConfig createFromXmlFile(File solverConfigFile) {
        return SolverConfig.createFromXmlFile(solverConfigFile, null);
    }

    public static SolverConfig createFromXmlFile(File solverConfigFile, ClassLoader classLoader) {
        SolverConfig solverConfig;
        FileInputStream in = new FileInputStream(solverConfigFile);
        try {
            solverConfig = SolverConfig.createFromXmlInputStream(in, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (OptaPlannerXmlSerializationException e) {
                throw new IllegalArgumentException("Unmarshalling the solverConfigFile (" + solverConfigFile + ") fails.", e);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The solverConfigFile (" + solverConfigFile + ") was not found.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading the solverConfigFile (" + solverConfigFile + ") fails.", e);
            }
        }
        ((InputStream)in).close();
        return solverConfig;
    }

    public static SolverConfig createFromXmlInputStream(InputStream in) {
        return SolverConfig.createFromXmlInputStream(in, null);
    }

    public static SolverConfig createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        SolverConfig solverConfig;
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            solverConfig = SolverConfig.createFromXmlReader(reader, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This vm does not support the charset (" + StandardCharsets.UTF_8 + ").", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Reading solverConfigInputStream fails.", e);
            }
        }
        ((Reader)reader).close();
        return solverConfig;
    }

    public static SolverConfig createFromXmlReader(Reader reader) {
        return SolverConfig.createFromXmlReader(reader, null);
    }

    public static SolverConfig createFromXmlReader(Reader reader, ClassLoader classLoader) {
        SolverConfigIO solverConfigIO = new SolverConfigIO();
        SolverConfig solverConfig = solverConfigIO.read(reader);
        solverConfig.setClassLoader(classLoader);
        return solverConfig;
    }

    public SolverConfig() {
    }

    public SolverConfig(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SolverConfig(SolverConfig inheritedConfig) {
        this.inherit(inheritedConfig);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public Boolean getDaemon() {
        return this.daemon;
    }

    public void setDaemon(Boolean daemon) {
        this.daemon = daemon;
    }

    public RandomType getRandomType() {
        return this.randomType;
    }

    public void setRandomType(RandomType randomType) {
        this.randomType = randomType;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public Class<? extends RandomFactory> getRandomFactoryClass() {
        return this.randomFactoryClass;
    }

    public void setRandomFactoryClass(Class<? extends RandomFactory> randomFactoryClass) {
        this.randomFactoryClass = randomFactoryClass;
    }

    public String getMoveThreadCount() {
        return this.moveThreadCount;
    }

    public void setMoveThreadCount(String moveThreadCount) {
        this.moveThreadCount = moveThreadCount;
    }

    public Integer getMoveThreadBufferSize() {
        return this.moveThreadBufferSize;
    }

    public void setMoveThreadBufferSize(Integer moveThreadBufferSize) {
        this.moveThreadBufferSize = moveThreadBufferSize;
    }

    public Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public Class<?> getSolutionClass() {
        return this.solutionClass;
    }

    public void setSolutionClass(Class<?> solutionClass) {
        this.solutionClass = solutionClass;
    }

    public List<Class<?>> getEntityClassList() {
        return this.entityClassList;
    }

    public void setEntityClassList(List<Class<?>> entityClassList) {
        this.entityClassList = entityClassList;
    }

    public DomainAccessType getDomainAccessType() {
        return this.domainAccessType;
    }

    public void setDomainAccessType(DomainAccessType domainAccessType) {
        this.domainAccessType = domainAccessType;
    }

    public Map<String, MemberAccessor> getGizmoMemberAccessorMap() {
        return this.gizmoMemberAccessorMap;
    }

    public void setGizmoMemberAccessorMap(Map<String, MemberAccessor> gizmoMemberAccessorMap) {
        this.gizmoMemberAccessorMap = gizmoMemberAccessorMap;
    }

    public Map<String, SolutionCloner> getGizmoSolutionClonerMap() {
        return this.gizmoSolutionClonerMap;
    }

    public void setGizmoSolutionClonerMap(Map<String, SolutionCloner> gizmoSolutionClonerMap) {
        this.gizmoSolutionClonerMap = gizmoSolutionClonerMap;
    }

    public ScoreDirectorFactoryConfig getScoreDirectorFactoryConfig() {
        return this.scoreDirectorFactoryConfig;
    }

    public void setScoreDirectorFactoryConfig(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
    }

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public List<PhaseConfig> getPhaseConfigList() {
        return this.phaseConfigList;
    }

    public void setPhaseConfigList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
    }

    public MonitoringConfig getMonitoringConfig() {
        return this.monitoringConfig;
    }

    public void setMonitoringConfig(MonitoringConfig monitoringConfig) {
        this.monitoringConfig = monitoringConfig;
    }

    public SolverConfig withEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
        return this;
    }

    public SolverConfig withDaemon(Boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public SolverConfig withRandomType(RandomType randomType) {
        this.randomType = randomType;
        return this;
    }

    public SolverConfig withRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
        return this;
    }

    public SolverConfig withRandomFactoryClass(Class<? extends RandomFactory> randomFactoryClass) {
        this.randomFactoryClass = randomFactoryClass;
        return this;
    }

    public SolverConfig withMoveThreadCount(String moveThreadCount) {
        this.moveThreadCount = moveThreadCount;
        return this;
    }

    public SolverConfig withMoveThreadBufferSize(Integer moveThreadBufferSize) {
        this.moveThreadBufferSize = moveThreadBufferSize;
        return this;
    }

    public SolverConfig withThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
        return this;
    }

    public SolverConfig withSolutionClass(Class<?> solutionClass) {
        this.solutionClass = solutionClass;
        return this;
    }

    public SolverConfig withEntityClassList(List<Class<?>> entityClassList) {
        this.entityClassList = entityClassList;
        return this;
    }

    public SolverConfig withEntityClasses(Class<?> ... entityClasses) {
        this.entityClassList = Arrays.asList(entityClasses);
        return this;
    }

    public SolverConfig withDomainAccessType(DomainAccessType domainAccessType) {
        this.domainAccessType = domainAccessType;
        return this;
    }

    public SolverConfig withGizmoMemberAccessorMap(Map<String, MemberAccessor> memberAccessorMap) {
        this.gizmoMemberAccessorMap = memberAccessorMap;
        return this;
    }

    public SolverConfig withGizmoSolutionClonerMap(Map<String, SolutionCloner> solutionClonerMap) {
        this.gizmoSolutionClonerMap = solutionClonerMap;
        return this;
    }

    public SolverConfig withScoreDirectorFactory(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        this.scoreDirectorFactoryConfig = scoreDirectorFactoryConfig;
        return this;
    }

    public SolverConfig withEasyScoreCalculatorClass(Class<? extends EasyScoreCalculator> easyScoreCalculatorClass) {
        if (this.scoreDirectorFactoryConfig == null) {
            this.scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        }
        this.scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(easyScoreCalculatorClass);
        return this;
    }

    public SolverConfig withConstraintProviderClass(Class<? extends ConstraintProvider> constraintProviderClass) {
        if (this.scoreDirectorFactoryConfig == null) {
            this.scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        }
        this.scoreDirectorFactoryConfig.setConstraintProviderClass(constraintProviderClass);
        return this;
    }

    public SolverConfig withConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        if (this.scoreDirectorFactoryConfig == null) {
            this.scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        }
        this.scoreDirectorFactoryConfig.setConstraintStreamImplType(constraintStreamImplType);
        return this;
    }

    public SolverConfig withTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
        return this;
    }

    public SolverConfig withTerminationSpentLimit(Duration spentLimit) {
        if (this.terminationConfig == null) {
            this.terminationConfig = new TerminationConfig();
        }
        this.terminationConfig.setSpentLimit(spentLimit);
        return this;
    }

    public SolverConfig withPhaseList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
        return this;
    }

    public SolverConfig withPhases(PhaseConfig ... phaseConfigs) {
        this.phaseConfigList = Arrays.asList(phaseConfigs);
        return this;
    }

    public SolverConfig withMonitoringConfig(MonitoringConfig monitoringConfig) {
        this.monitoringConfig = monitoringConfig;
        return this;
    }

    public EnvironmentMode determineEnvironmentMode() {
        return Objects.requireNonNullElse(this.environmentMode, EnvironmentMode.REPRODUCIBLE);
    }

    public DomainAccessType determineDomainAccessType() {
        return Objects.requireNonNullElse(this.domainAccessType, DomainAccessType.REFLECTION);
    }

    public MonitoringConfig determineMetricConfig() {
        return Objects.requireNonNullElse(this.monitoringConfig, new MonitoringConfig().withSolverMetricList(Arrays.asList(SolverMetric.SOLVE_DURATION, SolverMetric.ERROR_COUNT, SolverMetric.SCORE_CALCULATION_COUNT)));
    }

    public void offerRandomSeedFromSubSingleIndex(long subSingleIndex) {
        if ((this.environmentMode == null || this.environmentMode.isReproducible()) && this.randomFactoryClass == null && this.randomSeed == null) {
            this.randomSeed = subSingleIndex;
        }
    }

    @Override
    public SolverConfig inherit(SolverConfig inheritedConfig) {
        this.classLoader = ConfigUtils.inheritOverwritableProperty(this.classLoader, inheritedConfig.getClassLoader());
        this.environmentMode = ConfigUtils.inheritOverwritableProperty(this.environmentMode, inheritedConfig.getEnvironmentMode());
        this.daemon = ConfigUtils.inheritOverwritableProperty(this.daemon, inheritedConfig.getDaemon());
        this.randomType = ConfigUtils.inheritOverwritableProperty(this.randomType, inheritedConfig.getRandomType());
        this.randomSeed = ConfigUtils.inheritOverwritableProperty(this.randomSeed, inheritedConfig.getRandomSeed());
        this.randomFactoryClass = ConfigUtils.inheritOverwritableProperty(this.randomFactoryClass, inheritedConfig.getRandomFactoryClass());
        this.moveThreadCount = ConfigUtils.inheritOverwritableProperty(this.moveThreadCount, inheritedConfig.getMoveThreadCount());
        this.moveThreadBufferSize = ConfigUtils.inheritOverwritableProperty(this.moveThreadBufferSize, inheritedConfig.getMoveThreadBufferSize());
        this.threadFactoryClass = ConfigUtils.inheritOverwritableProperty(this.threadFactoryClass, inheritedConfig.getThreadFactoryClass());
        this.solutionClass = ConfigUtils.inheritOverwritableProperty(this.solutionClass, inheritedConfig.getSolutionClass());
        this.entityClassList = ConfigUtils.inheritMergeableListProperty(this.entityClassList, inheritedConfig.getEntityClassList());
        this.domainAccessType = ConfigUtils.inheritOverwritableProperty(this.domainAccessType, inheritedConfig.getDomainAccessType());
        this.gizmoMemberAccessorMap = ConfigUtils.inheritMergeableMapProperty(this.gizmoMemberAccessorMap, inheritedConfig.getGizmoMemberAccessorMap());
        this.gizmoSolutionClonerMap = ConfigUtils.inheritMergeableMapProperty(this.gizmoSolutionClonerMap, inheritedConfig.getGizmoSolutionClonerMap());
        this.scoreDirectorFactoryConfig = ConfigUtils.inheritConfig(this.scoreDirectorFactoryConfig, inheritedConfig.getScoreDirectorFactoryConfig());
        this.terminationConfig = ConfigUtils.inheritConfig(this.terminationConfig, inheritedConfig.getTerminationConfig());
        this.phaseConfigList = ConfigUtils.inheritMergeableListConfig(this.phaseConfigList, inheritedConfig.getPhaseConfigList());
        this.monitoringConfig = ConfigUtils.inheritConfig(this.monitoringConfig, inheritedConfig.getMonitoringConfig());
        return this;
    }

    @Override
    public SolverConfig copyConfig() {
        return new SolverConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        classVisitor.accept(this.randomFactoryClass);
        classVisitor.accept(this.threadFactoryClass);
        classVisitor.accept(this.solutionClass);
        if (this.entityClassList != null) {
            this.entityClassList.forEach(classVisitor);
        }
        if (this.scoreDirectorFactoryConfig != null) {
            this.scoreDirectorFactoryConfig.visitReferencedClasses(classVisitor);
        }
        if (this.terminationConfig != null) {
            this.terminationConfig.visitReferencedClasses(classVisitor);
        }
        if (this.phaseConfigList != null) {
            this.phaseConfigList.forEach(pc -> pc.visitReferencedClasses(classVisitor));
        }
    }
}

