/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.nearby;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.RandomNearbyIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.nearby.AbstractNearbyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.nearby.ListValueNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.value.nearby.OriginalNearbyValueIterator;

public final class NearValueNearbyValueSelector<Solution_>
extends AbstractNearbyValueSelector<Solution_, EntityIndependentValueSelector<Solution_>, MimicReplayingValueSelector<Solution_>>
implements EntityIndependentValueSelector<Solution_> {
    public NearValueNearbyValueSelector(EntityIndependentValueSelector<Solution_> childValueSelector, EntityIndependentValueSelector<Solution_> originValueSelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        super(childValueSelector, originValueSelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return ((EntityIndependentValueSelector)this.childSelector).getVariableDescriptor();
    }

    @Override
    protected MimicReplayingValueSelector<Solution_> castReplayingSelector(Object uncastReplayingSelector) {
        if (!(uncastReplayingSelector instanceof MimicReplayingValueSelector)) {
            throw new IllegalStateException("Impossible state: Nearby value selector (" + this + ") did not receive a replaying value selector (" + uncastReplayingSelector + ").");
        }
        return (MimicReplayingValueSelector)uncastReplayingSelector;
    }

    @Override
    protected AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> createDemand() {
        return new ListValueNearbyDistanceMatrixDemand(this.nearbyDistanceMeter, this.nearbyRandom, (EntityIndependentValueSelector)this.childSelector, (MimicReplayingValueSelector)this.replayingSelector, this::computeDestinationSize);
    }

    private int computeDestinationSize(Object origin) {
        int overallSizeMaximum;
        long childSize = ((EntityIndependentValueSelector)this.childSelector).getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childValueSelector (" + this.childSelector + ") has a valueSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        int destinationSize = (int)childSize;
        if (this.randomSelection && destinationSize > (overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum())) {
            destinationSize = overallSizeMaximum;
        }
        return destinationSize;
    }

    @Override
    public boolean isCountable() {
        return ((EntityIndependentValueSelector)this.childSelector).isCountable();
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return ((EntityIndependentValueSelector)this.childSelector).getSize();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        Iterator<Object> replayingOriginValueIterator = ((MimicReplayingValueSelector)this.replayingSelector).iterator();
        if (!this.randomSelection) {
            return new OriginalNearbyValueIterator(this.nearbyDistanceMatrix, replayingOriginValueIterator, ((EntityIndependentValueSelector)this.childSelector).getSize(), false);
        }
        return new RandomNearbyIterator(this.nearbyDistanceMatrix, this.nearbyRandom, this.workingRandom, replayingOriginValueIterator, ((EntityIndependentValueSelector)this.childSelector).getSize(), false);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return ((EntityIndependentValueSelector)this.childSelector).endingIterator(entity);
    }
}

