/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.io.jaxb;

import java.io.Reader;
import java.io.Writer;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.io.jaxb.ElementNamespaceOverride;
import org.optaplanner.core.impl.io.jaxb.GenericJaxbIO;
import org.optaplanner.core.impl.io.jaxb.JaxbIO;
import org.w3c.dom.Document;

public class SolverConfigIO
implements JaxbIO<SolverConfig> {
    private static final String SOLVER_XSD_RESOURCE = "/solver.xsd";
    private final GenericJaxbIO<SolverConfig> genericJaxbIO = new GenericJaxbIO<SolverConfig>(SolverConfig.class);

    @Override
    public SolverConfig read(Reader reader) {
        Document document = this.genericJaxbIO.parseXml(reader);
        String rootElementNamespace = document.getDocumentElement().getNamespaceURI();
        if ("https://www.optaplanner.org/xsd/solver".equals(rootElementNamespace)) {
            return this.genericJaxbIO.readAndValidate(document, SOLVER_XSD_RESOURCE);
        }
        if (rootElementNamespace == null || rootElementNamespace.isEmpty()) {
            return this.genericJaxbIO.readOverridingNamespace(document, ElementNamespaceOverride.of("solver", "https://www.optaplanner.org/xsd/solver"));
        }
        String errorMessage = String.format("The <%s/> element belongs to a different namespace (%s) than expected (%s).\nMaybe you passed a benchmark configuration to a method expecting a solver configuration.", "solver", rootElementNamespace, "https://www.optaplanner.org/xsd/solver");
        throw new IllegalArgumentException(errorMessage);
    }

    @Override
    public void write(SolverConfig solverConfig, Writer writer) {
        this.genericJaxbIO.writeWithoutNamespaces(solverConfig, writer);
    }
}

