/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

public abstract class AbstractXmlSolutionImporter<Solution_>
extends AbstractSolutionImporter<Solution_> {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = "xml";

    @Override
    public String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    public abstract XmlInputBuilder<Solution_> createXmlInputBuilder();

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Solution_ readSolution(File inputFile) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));){
            Solution_ Solution_;
            SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
            builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
            builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
            builder.setExpandEntities(false);
            Document document = builder.build((InputStream)in);
            XmlInputBuilder<Solution_> xmlInputBuilder = this.createXmlInputBuilder();
            xmlInputBuilder.setInputFile(inputFile);
            xmlInputBuilder.setDocument(document);
            try {
                Solution_ solution = xmlInputBuilder.readSolution();
                this.logger.info("Imported: {}", (Object)inputFile);
                Solution_ = solution;
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new IllegalArgumentException("Exception in inputFile (" + inputFile + ")", e);
            }
            return Solution_;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the file (" + inputFile.getName() + ").", e);
        }
        catch (JDOMException e) {
            throw new IllegalArgumentException("Could not parse the XML file (" + inputFile.getName() + ").", e);
        }
    }

    public static abstract class XmlInputBuilder<Solution_>
    extends AbstractSolutionImporter.InputBuilder {
        protected File inputFile;
        protected Document document;

        public void setInputFile(File inputFile) {
            this.inputFile = inputFile;
        }

        public void setDocument(Document document) {
            this.document = document;
        }

        public abstract Solution_ readSolution() throws IOException, JDOMException;

        public String getInputId() {
            return SolutionBusiness.getBaseFileName(this.inputFile);
        }

        protected void assertElementName(Element element, String name) {
            if (!element.getName().equals(name)) {
                throw new IllegalStateException("Element name (" + element.getName() + ") should be " + name + ".");
            }
        }
    }
}

