/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.persistence;

import java.io.File;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractJsonSolutionFileIO;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;

public class NurseRosterSolutionFileIO
extends AbstractJsonSolutionFileIO<NurseRoster> {
    public NurseRosterSolutionFileIO() {
        super(NurseRoster.class);
    }

    public NurseRoster read(File inputSolutionFile) {
        NurseRoster nurseRoster = (NurseRoster)super.read(inputSolutionFile);
        Map requestsById = nurseRoster.getShiftDateList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        Map shiftsById = nurseRoster.getShiftList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (Employee employee : nurseRoster.getEmployeeList()) {
            employee.setDayOffRequestMap(this.deduplicateMap(employee.getDayOffRequestMap(), requestsById, AbstractPersistable::getId));
            employee.setDayOnRequestMap(this.deduplicateMap(employee.getDayOnRequestMap(), requestsById, AbstractPersistable::getId));
            employee.setShiftOffRequestMap(this.deduplicateMap(employee.getShiftOffRequestMap(), shiftsById, AbstractPersistable::getId));
            employee.setShiftOnRequestMap(this.deduplicateMap(employee.getShiftOnRequestMap(), shiftsById, AbstractPersistable::getId));
        }
        return nurseRoster;
    }
}

