/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import org.drools.base.base.ValueResolver;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.BaseTuple;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.model.BitMask;
import org.drools.model.Channel;
import org.drools.model.Drools;
import org.drools.model.DroolsEntryPoint;
import org.drools.modelcompiler.consequence.ChannelImpl;
import org.drools.modelcompiler.consequence.DroolsEntryPointImpl;
import org.drools.modelcompiler.consequence.FactHandleLookup;
import org.drools.modelcompiler.util.EvaluationUtil;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleContext;

public class DroolsImpl
implements Drools,
RuleContext {
    private final KnowledgeHelper knowledgeHelper;
    private final ReteEvaluator reteEvaluator;
    private final FactHandleLookup fhLookup;

    DroolsImpl(KnowledgeHelper knowledgeHelper, ValueResolver valueResolver, FactHandleLookup fhLookup) {
        this.reteEvaluator = (ReteEvaluator)valueResolver;
        this.knowledgeHelper = knowledgeHelper;
        this.fhLookup = fhLookup;
    }

    public void insert(Object object) {
        this.insert(object, false);
    }

    public void insert(Object object, boolean dynamic) {
        TerminalNode terminalNode = ((InternalMatch)this.getMatch()).getTerminalNode();
        ((InternalWorkingMemoryEntryPoint)this.reteEvaluator.getDefaultEntryPoint()).insert(object, dynamic, this.getRule(), terminalNode);
    }

    public void logicalInsert(Object object) {
        this.knowledgeHelper.insertLogical(object);
    }

    public void insertAsync(Object object) {
        ((InternalWorkingMemoryEntryPoint)this.reteEvaluator.getDefaultEntryPoint()).insertAsync(object);
    }

    public RuleImpl getRule() {
        return (RuleImpl)this.knowledgeHelper.getRule();
    }

    public Match getMatch() {
        return this.knowledgeHelper.getMatch();
    }

    public FactHandle insertLogical(Object object) {
        return this.knowledgeHelper.insertLogical(object);
    }

    public FactHandle insertLogical(Object object, Object value) {
        return this.knowledgeHelper.insertLogical(object, value);
    }

    public FactHandle insertLogical(EntryPoint ep, Object object) {
        return this.knowledgeHelper.insertLogical(ep, object);
    }

    public void blockMatch(Match match) {
        this.knowledgeHelper.blockMatch(match);
    }

    public void unblockAllMatches(Match match) {
        this.knowledgeHelper.unblockAllMatches(match);
    }

    public void cancelMatch(Match match) {
        this.knowledgeHelper.cancelMatch(match);
    }

    public void update(Object object, String ... modifiedProperties) {
        org.drools.core.util.bitmask.BitMask mask = NamedEntryPoint.calculateUpdateBitMask((InternalRuleBase)this.reteEvaluator.getKnowledgeBase(), (Object)object, (String[])modifiedProperties);
        this.knowledgeHelper.update(this.getFactHandleForObject(object), mask, object.getClass());
    }

    private FactHandle getFactHandleForObject(Object object) {
        FactHandle fh = this.fhLookup.get(object);
        return fh != null ? fh : this.reteEvaluator.getFactHandle(object);
    }

    public void update(Object object, BitMask modifiedProperties) {
        Class modifiedClass = modifiedProperties.getPatternClass();
        this.knowledgeHelper.update(this.getFactHandleForObject(object), EvaluationUtil.adaptBitMask(modifiedProperties), modifiedClass);
    }

    public void update(FactHandle handle, Object newObject) {
        this.knowledgeHelper.update(handle, newObject);
    }

    public void delete(Object object) {
        this.knowledgeHelper.delete(this.getFactHandleForObject(object));
    }

    public <T> T getRuntime(Class<T> runtimeClass) {
        return (T)this.knowledgeHelper.getKieRuntime();
    }

    public <T> T getContext(Class<T> contextClass) {
        return (T)this.knowledgeHelper.getContext(contextClass);
    }

    public DroolsEntryPoint getEntryPoint(String name) {
        return new DroolsEntryPointImpl(this.knowledgeHelper.getEntryPoint(name), this.fhLookup);
    }

    public void halt() {
        this.knowledgeHelper.halt();
    }

    public void setFocus(String focus) {
        this.knowledgeHelper.setFocus(focus);
    }

    public KieBase getKieBase() {
        return (KieBase)this.reteEvaluator.getKnowledgeBase();
    }

    public KieRuntime getKieRuntime() {
        return this.knowledgeHelper.getKieRuntime();
    }

    public KieRuntime getKnowledgeRuntime() {
        return this.knowledgeHelper.getKieRuntime();
    }

    public KnowledgeHelper asKnowledgeHelper() {
        return this.knowledgeHelper;
    }

    public Channel getChannel(String name) {
        return new ChannelImpl(this.knowledgeHelper.getChannel(name));
    }

    public WorkingMemory getWorkingMemory() {
        return this.knowledgeHelper.getWorkingMemory();
    }

    public BaseTuple getTuple() {
        return this.knowledgeHelper.getTuple();
    }
}

