/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.bi;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.drools.DroolsConstraintFactory;
import org.optaplanner.constraint.streams.drools.bi.DroolsAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.drools.common.BiLeftHandSide;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;

public final class DroolsExistsBiConstraintStream<Solution_, A, B>
extends DroolsAbstractBiConstraintStream<Solution_, A, B> {
    private final DroolsAbstractBiConstraintStream<Solution_, A, B> parent;
    private final Supplier<BiLeftHandSide<A, B>> leftHandSide;
    private final String streamName;

    public <C> DroolsExistsBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent, boolean shouldExist, boolean shouldIncludeNullVars, Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        Predicate nullityFilter = shouldIncludeNullVars ? null : constraintFactory.getNullityFilter(otherClass);
        this.leftHandSide = () -> shouldExist ? ((BiLeftHandSide)parent.createLeftHandSide()).andExists(otherClass, joiners, nullityFilter) : ((BiLeftHandSide)parent.createLeftHandSide()).andNotExists(otherClass, joiners, nullityFilter);
        this.streamName = shouldExist ? "BiIfExists()" : "BiIfNotExists()";
    }

    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public BiLeftHandSide<A, B> createLeftHandSide() {
        return this.leftHandSide.get();
    }

    public String toString() {
        return this.streamName + " with " + this.getChildStreams().size() + " children";
    }
}

