/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase;

import java.util.Objects;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.phase.PhaseFactory;
import org.optaplanner.core.impl.solver.termination.PhaseToSolverTerminationBridge;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.termination.TerminationFactory;

public abstract class AbstractPhaseFactory<Solution_, PhaseConfig_ extends PhaseConfig<PhaseConfig_>>
implements PhaseFactory<Solution_> {
    protected final PhaseConfig_ phaseConfig;

    public AbstractPhaseFactory(PhaseConfig_ phaseConfig) {
        this.phaseConfig = phaseConfig;
    }

    protected Termination<Solution_> buildPhaseTermination(HeuristicConfigPolicy<Solution_> configPolicy, Termination<Solution_> solverTermination) {
        TerminationConfig terminationConfig_ = Objects.requireNonNullElseGet(((PhaseConfig)this.phaseConfig).getTerminationConfig(), TerminationConfig::new);
        PhaseToSolverTerminationBridge<Solution_> phaseTermination = new PhaseToSolverTerminationBridge<Solution_>(solverTermination);
        return TerminationFactory.create(terminationConfig_).buildTermination(configPolicy, phaseTermination);
    }
}

