/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.subsingle.pickedmovetypebestscore;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.YIntervalRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticRegistry;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import org.optaplanner.benchmark.impl.statistic.subsingle.pickedmovetypebestscore.PickedMoveTypeBestScoreDiffStatisticPoint;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class PickedMoveTypeBestScoreDiffSubSingleStatistic<Solution_>
extends PureSubSingleStatistic<Solution_, PickedMoveTypeBestScoreDiffStatisticPoint> {
    @XmlTransient
    protected List<File> graphFileList = null;

    PickedMoveTypeBestScoreDiffSubSingleStatistic() {
    }

    public PickedMoveTypeBestScoreDiffSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, SingleStatisticType.PICKED_MOVE_TYPE_BEST_SCORE_DIFF);
    }

    @Override
    public List<File> getGraphFileList() {
        return this.graphFileList;
    }

    @Override
    public void open(StatisticRegistry<Solution_> registry, Tags runTag, Solver<Solution_> solver) {
        registry.addListener(SolverMetric.PICKED_MOVE_TYPE_BEST_SCORE_DIFF, (timeMillisSpent, stepScope) -> {
            if (stepScope instanceof LocalSearchStepScope) {
                String moveType = ((LocalSearchStepScope)stepScope).getStep().getSimpleMoveTypeDescription();
                registry.extractScoreFromMeters(SolverMetric.PICKED_MOVE_TYPE_BEST_SCORE_DIFF, runTag.and(new Tag[]{Tag.of((String)"move.type", (String)moveType)}), score -> this.pointList.add(new PickedMoveTypeBestScoreDiffStatisticPoint((long)timeMillisSpent, moveType, (Score)score)));
            }
        });
    }

    @Override
    protected String getCsvHeader() {
        return PickedMoveTypeBestScoreDiffStatisticPoint.buildCsvLine("timeMillisSpent", "moveType", "bestScoreDiff");
    }

    @Override
    protected PickedMoveTypeBestScoreDiffStatisticPoint createPointFromCsvLine(ScoreDefinition<?> scoreDefinition, List<String> csvLine) {
        return new PickedMoveTypeBestScoreDiffStatisticPoint(Long.parseLong(csvLine.get(0)), csvLine.get(1), scoreDefinition.parseScore(csvLine.get(2)));
    }

    @Override
    public void writeGraphFiles(BenchmarkReport benchmarkReport) {
        ArrayList moveTypeToSeriesMapList = new ArrayList(15);
        for (PickedMoveTypeBestScoreDiffStatisticPoint point : this.getPointList()) {
            long timeMillisSpent = point.getTimeMillisSpent();
            String moveType = point.getMoveType();
            double[] levelValues = point.getBestScoreDiff().toLevelDoubles();
            for (int i = 0; i < levelValues.length && i < 15; ++i) {
                if (i >= moveTypeToSeriesMapList.size()) {
                    moveTypeToSeriesMapList.add(new LinkedHashMap());
                }
                Map moveTypeToSeriesMap = (Map)moveTypeToSeriesMapList.get(i);
                XYIntervalSeries series = moveTypeToSeriesMap.computeIfAbsent(moveType, k -> new XYIntervalSeries((Comparable)((Object)moveType)));
                double yValue = levelValues[i];
                series.add((double)timeMillisSpent, (double)timeMillisSpent, (double)timeMillisSpent, yValue, Math.min(yValue, 0.0), Math.max(yValue, 0.0));
            }
        }
        this.graphFileList = new ArrayList<File>(moveTypeToSeriesMapList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < moveTypeToSeriesMapList.size(); ++scoreLevelIndex) {
            XYPlot plot = this.createPlot(benchmarkReport, scoreLevelIndex);
            YIntervalRenderer renderer = new YIntervalRenderer();
            plot.setRenderer((XYItemRenderer)renderer);
            XYIntervalSeriesCollection seriesCollection = new XYIntervalSeriesCollection();
            for (XYIntervalSeries series : ((Map)moveTypeToSeriesMapList.get(scoreLevelIndex)).values()) {
                seriesCollection.addSeries(series);
            }
            plot.setDataset((XYDataset)seriesCollection);
            String scoreLevelLabel = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().findScoreLevelLabel(scoreLevelIndex);
            JFreeChart chart = new JFreeChart(this.subSingleBenchmarkResult.getName() + " picked move type best " + scoreLevelLabel + " diff statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.graphFileList.add(this.writeChartToImageFile(chart, "PickedMoveTypeBestScoreDiffStatisticLevel" + scoreLevelIndex));
        }
    }

    private XYPlot createPlot(BenchmarkReport benchmarkReport, int scoreLevelIndex) {
        Locale locale = benchmarkReport.getLocale();
        NumberAxis xAxis = new NumberAxis("Time spent");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpentNumberFormat(locale));
        String scoreLevelLabel = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().findScoreLevelLabel(scoreLevelIndex);
        NumberAxis yAxis = new NumberAxis("Best " + scoreLevelLabel + "  diff");
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(true);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }
}

