/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ValueType;
import org.drools.base.common.DroolsObjectInput;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.util.ClassUtils;

public abstract class BaseClassFieldReader
implements ReadAccessor,
Externalizable {
    private int index;
    private Class<?> fieldType;
    private ValueType valueType;

    public BaseClassFieldReader() {
    }

    protected BaseClassFieldReader(int index, Class<?> fieldType, ValueType valueType) {
        this.index = index;
        this.fieldType = fieldType;
        this.valueType = valueType;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    @Override
    public Class<?> getExtractToClass() {
        return this.fieldType;
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.fieldType);
    }

    public void setFieldType(Class<?> fieldType) {
        this.fieldType = fieldType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.fieldType != null ? this.fieldType.hashCode() : 0);
        result = 31 * result + this.index;
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseClassFieldReader)) {
            return false;
        }
        BaseClassFieldReader other = (BaseClassFieldReader)object;
        return this.fieldType == other.fieldType && this.index == other.index && this.valueType.equals((Object)other.valueType);
    }

    @Override
    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }

    @Override
    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeObject((Object)this.valueType);
        if (this.fieldType == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.fieldType.getName());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.index = in.readInt();
        this.valueType = (ValueType)((Object)in.readObject());
        String clsName = in.readUTF();
        if (!clsName.isEmpty()) {
            try {
                this.fieldType = in instanceof DroolsObjectInput ? ClassUtils.getClassFromName((String)clsName, (boolean)false, (ClassLoader)((DroolsObjectInput)in).getClassLoader()) : ClassUtils.getClassFromName((String)clsName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

