/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.rule.EntryPointId;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.util.bitmask.BitMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPointNode
extends ObjectSource
implements ObjectSink {
    private static final long serialVersionUID = 510L;
    protected static final transient Logger log = LoggerFactory.getLogger(EntryPointNode.class);
    private EntryPointId entryPoint;
    protected Map<ObjectType, ObjectTypeNode> objectTypeNodes;
    protected ObjectTypeNode queryNode;
    private ObjectTypeNode activationNode;
    private ObjectTypeConfigurationRegistry typeConfReg;

    public EntryPointNode() {
    }

    public EntryPointNode(int id, ObjectSource objectSource, BuildContext context) {
        this(id, context.getPartitionId(), context.getRuleBase().getRuleBaseConfiguration().isMultithreadEvaluation(), objectSource, context.getCurrentEntryPoint());
    }

    public EntryPointNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, ObjectSource objectSource, EntryPointId entryPoint) {
        super(id, partitionId, partitionsEnabled, objectSource, 999, 999);
        this.entryPoint = entryPoint;
        this.objectTypeNodes = new ConcurrentHashMap<ObjectType, ObjectTypeNode>();
        this.hashcode = this.calculateHashCode();
        this.typeConfReg = new ObjectTypeConfigurationRegistry(objectSource.getRuleBase());
    }

    public ObjectTypeConfigurationRegistry getTypeConfReg() {
        return this.typeConfReg;
    }

    public short getType() {
        return 10;
    }

    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    void setEntryPoint(EntryPointId entryPoint) {
        this.entryPoint = entryPoint;
    }

    public ObjectTypeNode getQueryNode() {
        if (this.queryNode == null) {
            this.queryNode = this.objectTypeNodes.get(ClassObjectType.DroolsQuery_ObjectType);
        }
        return this.queryNode;
    }

    public void assertActivation(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            this.activationNode.propagateAssert(factHandle, context, reteEvaluator);
        }
    }

    public void retractActivation(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            this.activationNode.retractObject(factHandle, context, reteEvaluator);
        }
    }

    public void modifyActivation(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(factHandle.detachLinkedTuples());
            this.activationNode.modifyObject(factHandle, modifyPreviousTuples, context, reteEvaluator);
            modifyPreviousTuples.retractTuples(context, reteEvaluator);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, ReteEvaluator reteEvaluator) {
        if (log.isTraceEnabled()) {
            log.trace("Insert {}", (Object)handle.toString());
        }
        if (this.partitionsEnabled || !reteEvaluator.isThreadSafe()) {
            PropagationEntry.Insert.execute(handle, context, reteEvaluator, objectTypeConf);
        } else {
            reteEvaluator.addPropagation(new PropagationEntry.Insert(handle, context, reteEvaluator, objectTypeConf));
        }
    }

    public void modifyObject(InternalFactHandle handle, PropagationContext pctx, ObjectTypeConf objectTypeConf, ReteEvaluator reteEvaluator) {
        if (log.isTraceEnabled()) {
            log.trace("Update {}", (Object)handle.toString());
        }
        if (reteEvaluator.isThreadSafe()) {
            reteEvaluator.addPropagation(new PropagationEntry.Update(handle, pctx, objectTypeConf));
        } else {
            PropagationEntry.Update.execute(handle, pctx, objectTypeConf, reteEvaluator);
        }
    }

    public static void removeRightTuplesMatchingOTN(PropagationContext pctx, ReteEvaluator reteEvaluator, ModifyPreviousTuples modifyPreviousTuples, ObjectTypeNode node, int partition) {
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple(partition);
        while (rightTuple != null && ((BaseNode)rightTuple.getTupleSink()).getObjectTypeNode() == node) {
            modifyPreviousTuples.removeRightTuple(partition);
            modifyPreviousTuples.doRightDelete(pctx, reteEvaluator, rightTuple);
            rightTuple = modifyPreviousTuples.peekRightTuple(partition);
        }
        while (true) {
            LeftTuple leftTuple = modifyPreviousTuples.peekLeftTuple(partition);
            ObjectTypeNode otn = null;
            if (leftTuple != null) {
                LeftTupleSink leftTupleSink = (LeftTupleSink)leftTuple.getTupleSink();
                if (leftTupleSink instanceof LeftTupleSource) {
                    otn = leftTupleSink.getLeftTupleSource().getObjectTypeNode();
                } else if (leftTupleSink instanceof RuleTerminalNode) {
                    otn = ((RuleTerminalNode)leftTupleSink).getObjectTypeNode();
                }
            }
            if (otn != node) break;
            modifyPreviousTuples.removeLeftTuple(partition);
            modifyPreviousTuples.doDeleteObject(pctx, reteEvaluator, leftTuple);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException("This method should NEVER EVER be called");
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException("This method should NEVER EVER be called");
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, ReteEvaluator reteEvaluator) {
        if (log.isTraceEnabled()) {
            log.trace("Delete {}", (Object)handle.toString());
        }
        reteEvaluator.addPropagation(new PropagationEntry.Delete(this, handle, context, objectTypeConf));
    }

    public void propagateRetract(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, ReteEvaluator reteEvaluator) {
        ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes();
        if (cachedNodes == null) {
            return;
        }
        for (ObjectTypeNode cachedNode : cachedNodes) {
            cachedNode.retractObject(handle, context, reteEvaluator);
        }
        if (handle.isEvent()) {
            ((DefaultEventHandle)handle).unscheduleAllJobs(reteEvaluator);
        }
    }

    @Override
    public void addObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.put(node.getObjectType(), node);
    }

    @Override
    public void removeObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.remove(node.getObjectType());
    }

    public void removeObjectType(ObjectType objectType) {
        this.objectTypeNodes.remove(objectType);
    }

    public void attach() {
        this.doAttach(null);
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.source.addObjectSink(this);
        if (context != null) {
            for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
                workingMemory.updateEntryPointsCache();
            }
        }
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        return false;
    }

    public Map<ObjectType, ObjectTypeNode> getObjectTypeNodes() {
        return this.objectTypeNodes;
    }

    private int calculateHashCode() {
        return this.entryPoint.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof EntryPointNode && this.hashCode() == object.hashCode() && this.entryPoint.equals((Object)((EntryPointNode)object).entryPoint);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNode node = (ObjectTypeNode)sink;
        ObjectType newObjectType = node.getObjectType();
        WorkingMemoryEntryPoint wmEntryPoint = workingMemory.getEntryPoint(this.entryPoint.getEntryPointId());
        for (ObjectTypeConf objectTypeConf : wmEntryPoint.getObjectTypeConfigurationRegistry().values()) {
            if (objectTypeConf.getConcreteObjectTypeNode() == null || !newObjectType.isAssignableFrom(objectTypeConf.getConcreteObjectTypeNode().getObjectType())) continue;
            objectTypeConf.resetCache();
            ObjectTypeNode sourceNode = objectTypeConf.getConcreteObjectTypeNode();
            Iterator<InternalFactHandle> it = sourceNode.getFactHandlesIterator(workingMemory);
            while (it.hasNext()) {
                sink.assertObject(it.next(), context, workingMemory);
            }
        }
    }

    @Override
    public String toString() {
        return "[EntryPointNode(" + this.id + ") " + this.entryPoint + " ]";
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitMask calculateDeclaredMask(ObjectType modifiedType, List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }
}

