/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tennis.score;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.util.Pair;
import org.optaplanner.examples.tennis.domain.TeamAssignment;
import org.optaplanner.examples.tennis.domain.UnavailabilityPenalty;

public final class TennisConstraintProvider
implements ConstraintProvider {
    private static <A> UniConstraintCollector<A, ?, LoadBalanceData> loadBalance(final Function<A, Object> groupKey) {
        return new UniConstraintCollector<A, LoadBalanceData, LoadBalanceData>(){

            public Supplier<LoadBalanceData> supplier() {
                return () -> new LoadBalanceData();
            }

            public BiFunction<LoadBalanceData, A, Runnable> accumulator() {
                return (resultContainer, a) -> {
                    Object mapped = groupKey.apply(a);
                    return resultContainer.apply(mapped);
                };
            }

            public Function<LoadBalanceData, LoadBalanceData> finisher() {
                return Function.identity();
            }
        };
    }

    private static <A, B> BiConstraintCollector<A, B, ?, LoadBalanceData> loadBalance(final BiFunction<A, B, Object> groupKey) {
        return new BiConstraintCollector<A, B, LoadBalanceData, LoadBalanceData>(){

            public Supplier<LoadBalanceData> supplier() {
                return () -> new LoadBalanceData();
            }

            public TriFunction<LoadBalanceData, A, B, Runnable> accumulator() {
                return (resultContainer, a, b) -> {
                    Object mapped = groupKey.apply(a, b);
                    return resultContainer.apply(mapped);
                };
            }

            public Function<LoadBalanceData, LoadBalanceData> finisher() {
                return Function.identity();
            }
        };
    }

    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.oneAssignmentPerDatePerTeam(constraintFactory), this.unavailabilityPenalty(constraintFactory), this.fairAssignmentCountPerTeam(constraintFactory), this.evenlyConfrontationCount(constraintFactory)};
    }

    Constraint oneAssignmentPerDatePerTeam(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TeamAssignment.class).join(TeamAssignment.class, Joiners.equal(TeamAssignment::getTeam), Joiners.equal(TeamAssignment::getDay), Joiners.lessThan(AbstractPersistable::getId)).penalize((Score)HardMediumSoftScore.ONE_HARD).asConstraint("oneAssignmentPerDatePerTeam");
    }

    Constraint unavailabilityPenalty(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(UnavailabilityPenalty.class).ifExists(TeamAssignment.class, Joiners.equal(UnavailabilityPenalty::getTeam, TeamAssignment::getTeam), Joiners.equal(UnavailabilityPenalty::getDay, TeamAssignment::getDay)).penalize((Score)HardMediumSoftScore.ONE_HARD).asConstraint("unavailabilityPenalty");
    }

    Constraint fairAssignmentCountPerTeam(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TeamAssignment.class).groupBy(TennisConstraintProvider.loadBalance(TeamAssignment::getTeam)).penalize((Score)HardMediumSoftScore.ONE_MEDIUM, result -> (int)result.getZeroDeviationSquaredSumRootMillis()).asConstraint("fairAssignmentCountPerTeam");
    }

    Constraint evenlyConfrontationCount(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TeamAssignment.class).join(TeamAssignment.class, Joiners.equal(TeamAssignment::getDay), Joiners.lessThan(assignment -> assignment.getTeam().getId())).groupBy(TennisConstraintProvider.loadBalance((A assignment, B otherAssignment) -> Pair.of(assignment.getTeam(), otherAssignment.getTeam()))).penalize((Score)HardMediumSoftScore.ONE_SOFT, result -> (int)result.getZeroDeviationSquaredSumRootMillis()).asConstraint("evenlyConfrontationCount");
    }

    private static final class LoadBalanceData {
        private final Map<Object, Long> groupCountMap = new LinkedHashMap<Object, Long>(0);
        private long squaredSum = 0L;

        private LoadBalanceData() {
        }

        private Runnable apply(Object mapped) {
            long count = this.groupCountMap.compute(mapped, (key, value) -> value == null ? 1L : value + 1L);
            this.squaredSum += 2L * count - 1L;
            return () -> {
                Long computed = this.groupCountMap.compute(mapped, (key, value) -> value == 1L ? null : Long.valueOf(value - 1L));
                this.squaredSum -= computed == null ? 1L : 2L * computed + 1L;
            };
        }

        public long getZeroDeviationSquaredSumRootMillis() {
            return (long)(Math.sqrt(this.squaredSum) * 1000.0);
        }
    }
}

