/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.travelingtournament.persistence;

import java.io.File;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractJsonSolutionFileIO;
import org.optaplanner.examples.travelingtournament.domain.Team;
import org.optaplanner.examples.travelingtournament.domain.TravelingTournament;

public class TravelingTournamentSolutionFileIO
extends AbstractJsonSolutionFileIO<TravelingTournament> {
    public TravelingTournamentSolutionFileIO() {
        super(TravelingTournament.class);
    }

    public TravelingTournament read(File inputSolutionFile) {
        TravelingTournament travelingTournament = (TravelingTournament)super.read(inputSolutionFile);
        Map teamsById = travelingTournament.getTeamList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (Team team : travelingTournament.getTeamList()) {
            Map<Team, Integer> newTravelDistanceMap = this.deduplicateMap(team.getDistanceToTeamMap(), teamsById, AbstractPersistable::getId);
            team.setDistanceToTeamMap(newTravelDistanceMap);
        }
        return travelingTournament;
    }
}

