/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.ast.descr;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.ConditionalElementDescr;
import org.drools.drl.ast.descr.DescrVisitor;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.OrDescr;
import org.drools.drl.ast.descr.PatternDescr;

public class AndDescr
extends AnnotatedBaseDescr
implements ConditionalElementDescr {
    private static final long serialVersionUID = 510L;
    private List<BaseDescr> descrs = new ArrayList<BaseDescr>();

    public AndDescr() {
    }

    private AndDescr(BaseDescr baseDescr) {
        this.addDescr(baseDescr);
    }

    @Override
    public void addDescr(BaseDescr baseDescr) {
        this.descrs.add(baseDescr);
    }

    public void insertDescr(int index, BaseDescr baseDescr) {
        this.descrs.add(index, baseDescr);
    }

    @Override
    public void insertBeforeLast(Class<?> clazz, BaseDescr baseDescr) {
        if (this.descrs.isEmpty()) {
            this.addDescr(baseDescr);
            return;
        }
        for (int i = this.descrs.size() - 1; i >= 0; --i) {
            if (!clazz.isInstance(this.descrs.get(i))) continue;
            this.insertDescr(i, baseDescr);
            return;
        }
        this.addDescr(baseDescr);
    }

    public List<BaseDescr> getDescrs() {
        return this.descrs;
    }

    public List<PatternDescr> getAllPatternDescr() {
        ArrayList<PatternDescr> patterns = new ArrayList<PatternDescr>();
        this.getAllPatternDescr(this, patterns);
        return patterns;
    }

    private void getAllPatternDescr(ConditionalElementDescr elementDescr, List<PatternDescr> patterns) {
        for (BaseDescr baseDescr : elementDescr.getDescrs()) {
            if (baseDescr instanceof PatternDescr) {
                patterns.add((PatternDescr)baseDescr);
                continue;
            }
            if (!(baseDescr instanceof ConditionalElementDescr)) continue;
            this.getAllPatternDescr((ConditionalElementDescr)((Object)baseDescr), patterns);
        }
    }

    @Override
    public void addOrMerge(BaseDescr baseDescr) {
        if (baseDescr instanceof AndDescr) {
            AndDescr and = (AndDescr)baseDescr;
            for (BaseDescr descr : and.getDescrs()) {
                this.addDescr(descr);
            }
            for (String annKey : and.getAnnotationNames()) {
                this.addAnnotation(and.getAnnotation(annKey));
            }
        } else {
            this.addDescr(baseDescr);
        }
    }

    @Override
    public boolean removeDescr(BaseDescr baseDescr) {
        return baseDescr == null ? false : this.descrs.remove(baseDescr);
    }

    public String toString() {
        return "[AND " + this.descrs + " ]";
    }

    @Override
    public void accept(DescrVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BaseDescr negate() {
        BaseDescr baseDescr;
        if (this.descrs.isEmpty()) {
            return new AndDescr(new ExprConstraintDescr("false"));
        }
        if (!(this.descrs.size() != 1 || (baseDescr = this.descrs.get(0)) instanceof ExprConstraintDescr && !baseDescr.getText().contains("||") && baseDescr.getText().contains("&&"))) {
            return new AndDescr(baseDescr.negate());
        }
        boolean allExprs = this.descrs.stream().allMatch(ExprConstraintDescr.class::isInstance);
        if (allExprs) {
            String expr = this.descrs.stream().map(ExprConstraintDescr.class::cast).map(BaseDescr::getText).map(this::removeEnclosingParenthesis).flatMap(e -> Stream.of(e.split("&&"))).map(e -> "!(" + e + ")").collect(Collectors.joining("||"));
            return new AndDescr(new ExprConstraintDescr(expr));
        }
        OrDescr or = new OrDescr();
        for (BaseDescr descr : this.descrs) {
            or.addDescr(descr.negate());
        }
        return or;
    }

    private String removeEnclosingParenthesis(String expr) {
        return (expr = expr.trim()).startsWith("(") && expr.endsWith(")") ? this.removeEnclosingParenthesis(expr.substring(1, expr.length() - 1)) : expr;
    }
}

