/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.util.StringUtils;
import org.kie.api.PropertiesConfiguration;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.MultiValueOption;
import org.kie.api.conf.Option;
import org.kie.api.conf.OptionsConfiguration;
import org.kie.api.conf.SingleValueOption;
import org.kie.internal.conf.CompositeConfiguration;
import org.kie.internal.conf.InternalPropertiesConfiguration;
import org.kie.internal.utils.ChainedProperties;

public abstract class BaseConfiguration<T extends Option, S extends SingleValueOption, M extends MultiValueOption>
implements InternalPropertiesConfiguration,
PropertiesConfiguration,
Externalizable {
    protected CompositeConfiguration<T, S, M> compConfig;
    private volatile boolean immutable;

    public BaseConfiguration(CompositeConfiguration<T, S, M> compConfig) {
        this.compConfig = compConfig;
        this.immutable = false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.compConfig);
        out.writeBoolean(this.immutable);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.compConfig = (CompositeConfiguration)in.readObject();
        this.immutable = in.readBoolean();
    }

    public final boolean setProperty(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return false;
        }
        boolean set = this.setInternalProperty(name, value);
        if (!set) {
            set = this.compConfig.setProperty((PropertiesConfiguration)this, name, value);
        }
        return set;
    }

    public final String getProperty(String name) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return null;
        }
        String value = this.getInternalProperty(name);
        if (value == null) {
            value = this.compConfig.getProperty((PropertiesConfiguration)this, name);
        }
        return value;
    }

    public final void makeImmutable() {
        this.immutable = true;
    }

    public final boolean isImmutable() {
        return this.immutable;
    }

    protected final void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public final ClassLoader getClassLoader() {
        return this.compConfig.getClassLoader();
    }

    public final void setClassLoader(ClassLoader classLoader) {
        this.compConfig.setClassLoader(classLoader);
    }

    public final String getPropertyValue(String name, String defaultValue) {
        return this.compConfig.getProperties().getProperty(name, defaultValue);
    }

    public final ChainedProperties getProperties() {
        return this.compConfig.getProperties();
    }

    public final ChainedProperties getChainedProperties() {
        return this.compConfig.getProperties();
    }

    public final <X extends OptionsConfiguration<T, S, M>> X as(ConfigurationKey<X> key) {
        return (X)this.compConfig.as(key);
    }
}

