/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.io.jaxb.adapter;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class JaxbOffsetDateTimeAdapter
extends XmlAdapter<String, OffsetDateTime> {
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffsetId().toFormatter();

    public OffsetDateTime unmarshal(String offsetDateTimeString) {
        if (offsetDateTimeString == null) {
            return null;
        }
        try {
            return OffsetDateTime.from(this.formatter.parse(offsetDateTimeString));
        }
        catch (DateTimeException e) {
            throw new IllegalStateException("Failed to convert string (" + offsetDateTimeString + ") to type (" + OffsetDateTime.class.getName() + ").");
        }
    }

    public String marshal(OffsetDateTime offsetDateTimeObject) {
        if (offsetDateTimeObject == null) {
            return null;
        }
        return this.formatter.format(offsetDateTimeObject);
    }
}

