/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.accessor.TupleValueExtractor;

public class FieldIndex
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private TupleValueExtractor leftExtractor;
    private ReadAccessor rightExtractor;
    private boolean requiresCoercion;

    public FieldIndex() {
    }

    public FieldIndex(ReadAccessor rightExtractor, TupleValueExtractor leftExtractor) {
        this.rightExtractor = rightExtractor;
        this.leftExtractor = leftExtractor;
        this.requiresCoercion = this.isCoercionRequired(rightExtractor, leftExtractor);
    }

    private boolean isCoercionRequired(ReadAccessor extractor, TupleValueExtractor declaration) {
        return extractor.getValueType() != declaration.getValueType();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rightExtractor = (ReadAccessor)in.readObject();
        this.leftExtractor = (Declaration)in.readObject();
        this.requiresCoercion = this.isCoercionRequired(this.rightExtractor, this.leftExtractor);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rightExtractor);
        out.writeObject(this.leftExtractor);
    }

    public TupleValueExtractor getLeftExtractor() {
        return this.leftExtractor;
    }

    public ReadAccessor getRightExtractor() {
        return this.rightExtractor;
    }

    public boolean requiresCoercion() {
        return this.requiresCoercion;
    }

    public Object indexedValueOf(BaseTuple tuple, boolean left) {
        return left ? (this.requiresCoercion ? this.rightExtractor.getValueType().coerce(this.leftExtractor.getValue(tuple)) : this.leftExtractor.getValue(tuple)) : this.rightExtractor.getValue(null, tuple.getFactHandle().getObject());
    }
}

