/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.drools.compiler.lang.DumperContext;
import org.drools.compiler.lang.ExpressionRewriter;
import org.drools.compiler.lang.ReflectiveVisitor;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.drl.ast.descr.AtomicExprDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.ConnectiveType;
import org.drools.drl.ast.descr.ConstraintConnectiveDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.OperatorDescr;
import org.drools.drl.ast.descr.RelationalExprDescr;
import org.drools.drl.parser.DrlExprParser;
import org.drools.drl.parser.impl.Operator;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DescrDumper
extends ReflectiveVisitor
implements ExpressionRewriter {
    public static final String WM_ARGUMENT = "_workingMemory_";
    private static final DescrDumper INSTANCE = new DescrDumper();
    private static final Pattern evalRegexp = Pattern.compile("^eval\\s*\\(", 8);
    private static final String[] standard = new String[]{"==", "<", ">", ">=", "<=", "!=", "~=", "instanceof"};

    public static DescrDumper getInstance() {
        return INSTANCE;
    }

    @Override
    public String dump(BaseDescr base) {
        return this.dump(new StringBuilder(), base, 0, false, this.createContext()).toString();
    }

    @Override
    public String dump(BaseDescr base, DumperContext context) {
        return this.dump(new StringBuilder(), base, 0, false, context).toString();
    }

    @Override
    public String dump(BaseDescr base, ConstraintConnectiveDescr parent, DumperContext context) {
        return this.dump(new StringBuilder(), base, parent, 0, 0, false, context).toString();
    }

    @Override
    public String dump(BaseDescr base, int parentPrecedence) {
        return this.dump(new StringBuilder(), base, parentPrecedence, false, this.createContext()).toString();
    }

    @Override
    public StringBuilder dump(StringBuilder sbuilder, BaseDescr base, int parentPriority, boolean isInsideRelCons, DumperContext context) {
        return this.dump(sbuilder, base, null, 0, parentPriority, false, context);
    }

    @Override
    public StringBuilder dump(StringBuilder sbuilder, BaseDescr base, ConstraintConnectiveDescr parent, int parentIndex, int parentPriority, boolean isInsideRelCons, DumperContext context) {
        if (context == null) {
            context = this.createContext();
        }
        if (base instanceof ConstraintConnectiveDescr) {
            this.processConnectiveDescr(sbuilder, base, parentPriority, isInsideRelCons, context);
        } else if (base instanceof AtomicExprDescr) {
            this.processAtomicExpression(sbuilder, context, (AtomicExprDescr)base, parent, parentIndex);
        } else if (base instanceof BindingDescr) {
            this.processBinding(sbuilder, (BindingDescr)base, parent, isInsideRelCons, context);
        } else if (base instanceof RelationalExprDescr) {
            this.processRelationalExpression(sbuilder, (RelationalExprDescr)base, parent, context);
        } else if (base instanceof ExprConstraintDescr) {
            this.processConstraint(sbuilder, (ExprConstraintDescr)base, isInsideRelCons, context);
        }
        return sbuilder;
    }

    private void processConstraint(StringBuilder sbuilder, ExprConstraintDescr base, boolean isInsideRelCons, DumperContext context) {
        DrlExprParser expr = new DrlExprParser((LanguageLevelOption)context.getRuleContext().getConfiguration().getOption(LanguageLevelOption.KEY));
        ConstraintConnectiveDescr result = expr.parse(base.getExpression());
        if (result.getDescrs().size() == 1) {
            this.dump(sbuilder, (BaseDescr)result.getDescrs().get(0), 0, isInsideRelCons, context);
        } else {
            this.dump(sbuilder, (BaseDescr)result, 0, isInsideRelCons, context);
        }
    }

    private String[] processAtomicExpression(StringBuilder sbuilder, DumperContext context, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr parent, int parentIdx) {
        String expr = atomicExpr.getExpression().trim();
        expr = DescrDumper.normalizeEval(expr);
        String[] constrAndExpr = this.processImplicitConstraints(expr, atomicExpr, parent, parentIdx, context);
        String string = expr = context.isCcdNested() ? constrAndExpr[0] + constrAndExpr[1] : constrAndExpr[1];
        if (!atomicExpr.hasRewrittenExpression()) {
            atomicExpr.setRewrittenExpression(expr);
        }
        sbuilder.append(expr);
        return constrAndExpr;
    }

    private void processBinding(StringBuilder sbuilder, BindingDescr bind, ConstraintConnectiveDescr parent, boolean isInsideRelCons, DumperContext context) {
        String expr = bind.getExpression().trim();
        AtomicExprDescr atomicExpr = new AtomicExprDescr(expr);
        atomicExpr.setResource(parent.getResource());
        String[] constrAndExpr = this.processImplicitConstraints(expr, atomicExpr, parent, parent.getDescrs().indexOf(bind), context);
        if (isInsideRelCons) {
            sbuilder.append(constrAndExpr[0]).append(constrAndExpr[1]);
        } else if (constrAndExpr[0].length() > 4) {
            sbuilder.append(constrAndExpr[0], 0, constrAndExpr[0].length() - 4);
        }
        if (bind.getExpression().equals(bind.getBindingField())) {
            bind.setExpressionAndBindingField(constrAndExpr[1]);
        } else {
            bind.setExpression(constrAndExpr[1]);
        }
        context.addBinding(bind);
    }

    private void processRelationalExpression(StringBuilder sbuilder, RelationalExprDescr red, ConstraintConnectiveDescr parent, DumperContext context) {
        int idx = parent.getDescrs().indexOf(red);
        StringBuilder left = this.dump(new StringBuilder(), red.getLeft(), parent, idx, Integer.MAX_VALUE, true, context);
        String right = red.getRight() instanceof AtomicExprDescr ? this.processRightAtomicExpr(left, (AtomicExprDescr)red.getRight(), parent, idx, context) : this.dump(new StringBuilder(), red.getRight(), parent, idx, Integer.MAX_VALUE, true, context).toString();
        String expr = this.processRestriction(context, left.toString(), red.getOperatorDescr(), right);
        red.setExpression(expr);
        sbuilder.append(expr);
    }

    private String processRightAtomicExpr(StringBuilder left, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr parent, int parentIdx, DumperContext context) {
        String expr = atomicExpr.getExpression().trim();
        expr = DescrDumper.normalizeEval(expr);
        String[] constrAndExpr = this.processImplicitConstraints(expr, atomicExpr, parent, parentIdx, context);
        left.insert(0, constrAndExpr[0]);
        return this.processBackReference(context, atomicExpr, constrAndExpr[1]);
    }

    private String processBackReference(DumperContext context, AtomicExprDescr atomicExpr, String expr) {
        if (!context.isInXpath()) {
            return expr;
        }
        int i = 0;
        while (((String)expr).startsWith("../")) {
            ++i;
            expr = ((String)expr).substring(3).trim();
        }
        if (i > 0) {
            expr = "$back$ref$" + i + "." + (String)expr;
            atomicExpr.setRewrittenExpression((String)expr);
        }
        return expr;
    }

    public String[] processImplicitConstraints(String expr, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr parent, int parentIdx, DumperContext context) {
        boolean hasQuotes = expr.indexOf(34) >= 0;
        String[] constrAndExpr = new String[]{"", expr};
        int sharpPos = hasQuotes ? StringUtils.indexOfOutOfQuotes((String)expr, (char)'#') : expr.indexOf(35);
        int nullSafePos = hasQuotes ? StringUtils.indexOfOutOfQuotes((String)expr, (String)"!.") : expr.indexOf("!.");
        int j = 0;
        while (sharpPos > 0 || nullSafePos > 0) {
            if (nullSafePos < 0 || sharpPos > 0 && sharpPos < nullSafePos) {
                String[] castAndExpr = this.processInlineCast(expr, atomicExpr, parent, context, sharpPos, parentIdx, j++);
                expr = castAndExpr[1];
                constrAndExpr = new String[]{constrAndExpr[0] + castAndExpr[0], expr};
            } else {
                String[] nullCheckAndExpr = this.processNullSafeDereferencing(expr, atomicExpr, parent, nullSafePos, parentIdx, j++);
                expr = nullCheckAndExpr[1];
                constrAndExpr = new String[]{constrAndExpr[0] + nullCheckAndExpr[0], expr};
            }
            sharpPos = hasQuotes ? StringUtils.indexOfOutOfQuotes((String)expr, (char)'#') : expr.indexOf(35);
            nullSafePos = hasQuotes ? StringUtils.indexOfOutOfQuotes((String)expr, (String)"!.") : expr.indexOf("!.");
        }
        return new String[]{constrAndExpr[0], this.processInferredCast(constrAndExpr[1], atomicExpr, context)};
    }

    private String[] processInlineCast(String expr, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr ccd, DumperContext context, int sharpPos, int parentIdx, int childIdx) {
        BaseDescr desc;
        String field1 = expr.substring(0, sharpPos).trim();
        int sharpPos2 = expr.indexOf(35, sharpPos + 1);
        String part2 = sharpPos2 < 0 ? expr.substring(sharpPos + 1).trim() : expr.substring(sharpPos + 1, sharpPos2).trim();
        String[] classAndField = this.splitInClassAndField(part2, context);
        BaseDescr baseDescr = desc = parentIdx >= 0 ? (BaseDescr)ccd.getDescrs().get(parentIdx) : null;
        if (classAndField == null) {
            return new String[]{"", expr};
        }
        if (desc instanceof AtomicExprDescr && classAndField.length == 1) {
            return new String[]{"", field1 + " instanceof " + classAndField[0]};
        }
        String className = classAndField[0];
        String castedExpression = classAndField.length == 1 ? "((" + className + ")" + field1 + ")" : "((" + className + ")" + field1 + ")." + classAndField[1] + (sharpPos2 > 0 ? expr.substring(sharpPos2) : "");
        RelationalExprDescr check = new RelationalExprDescr("instanceof", false, null, (BaseDescr)new AtomicExprDescr(field1), (BaseDescr)new AtomicExprDescr(className));
        if (ccd.getConnective() == ConnectiveType.AND || ccd.getConnective() == ConnectiveType.INC_AND) {
            ccd.getDescrs().add(childIdx, check);
        } else if (desc instanceof ConstraintConnectiveDescr) {
            ((ConstraintConnectiveDescr)desc).getDescrs().add(childIdx, check);
        } else {
            ConstraintConnectiveDescr localAnd = new ConstraintConnectiveDescr(ConnectiveType.AND);
            BaseDescr original = (BaseDescr)ccd.getDescrs().remove(parentIdx);
            localAnd.getDescrs().add(check);
            localAnd.getDescrs().add(original);
            ccd.getDescrs().add(parentIdx, localAnd);
        }
        atomicExpr.setRewrittenExpression(castedExpression);
        String innerCheck = check + " && ";
        return new String[]{innerCheck, castedExpression};
    }

    private String processInferredCast(String expr, AtomicExprDescr atomicExpr, DumperContext context) {
        if (context == null) {
            return expr;
        }
        Map.Entry<String, String> castEntry = context.getInferredCast(expr);
        if (castEntry == null) {
            return expr;
        }
        String castedExpr = "((" + castEntry.getValue() + ")" + castEntry.getKey() + ")" + expr.substring(castEntry.getKey().length());
        atomicExpr.setRewrittenExpression(castedExpr);
        return castedExpr;
    }

    private String[] processNullSafeDereferencing(String expr, AtomicExprDescr atomicExpr, ConstraintConnectiveDescr ccd, int nullSafePos, int parentIdx, int childIdx) {
        String field1 = ((String)expr).substring(0, nullSafePos).trim();
        expr = field1 + "." + ((String)expr).substring(nullSafePos + 2).trim();
        RelationalExprDescr check = new RelationalExprDescr("!=", false, null, (BaseDescr)new AtomicExprDescr(this.getPreconditionsToAppend(field1)), (BaseDescr)new AtomicExprDescr("null"));
        if (ccd.getConnective() == ConnectiveType.AND || ccd.getConnective() == ConnectiveType.INC_AND) {
            ccd.getDescrs().add(childIdx, check);
        } else {
            BaseDescr desc = (BaseDescr)ccd.getDescrs().get(parentIdx);
            if (desc instanceof ConstraintConnectiveDescr) {
                ((ConstraintConnectiveDescr)desc).getDescrs().add(childIdx, check);
            } else {
                ConstraintConnectiveDescr localAnd = new ConstraintConnectiveDescr(ConnectiveType.AND);
                BaseDescr original = (BaseDescr)ccd.getDescrs().remove(parentIdx);
                localAnd.getDescrs().add(check);
                localAnd.getDescrs().add(original);
                ccd.getDescrs().add(parentIdx, localAnd);
            }
        }
        String innerCheck = check + " && ";
        String[] nullCheckAndExpr = new String[]{innerCheck, expr};
        atomicExpr.setRewrittenExpression((String)expr);
        return nullCheckAndExpr;
    }

    private String getPreconditionsToAppend(String field1) {
        int parenthesisDepth = 0;
        int squareDepth = 0;
        block7: for (int i = field1.length() - 1; i >= 0; --i) {
            switch (field1.charAt(i)) {
                case '(': {
                    if (--parenthesisDepth >= 0) continue block7;
                    return field1.substring(i + 1).trim();
                }
                case ')': {
                    ++parenthesisDepth;
                    continue block7;
                }
                case '[': {
                    if (--squareDepth >= 0) continue block7;
                    return field1.substring(i + 1).trim();
                }
                case ']': {
                    ++squareDepth;
                    continue block7;
                }
                case ',': {
                    if (squareDepth != 0 || parenthesisDepth != 0) continue block7;
                    return field1.substring(i + 1).trim();
                }
            }
        }
        return field1;
    }

    public static String normalizeEval(String expr) {
        String normalized = evalRegexp.matcher(expr).find() ? expr.substring(expr.indexOf(40) + 1, expr.lastIndexOf(41)) : expr;
        return normalized.contains("eval") ? expr : normalized;
    }

    private String[] splitInClassAndField(String expr, DumperContext context) {
        String[] split = expr.split("\\.");
        if (split.length < 2) {
            return new String[]{expr};
        }
        if (split[0].endsWith("!")) {
            split[0] = split[0].substring(0, split[0].length() - 1);
        }
        if (split.length < 3) {
            return split;
        }
        if (context == null || DialectUtil.findClassByName(context.getRuleContext(), split[0]) != null) {
            return new String[]{split[0], this.concatDotSeparated(split, 1, split.length)};
        }
        ClassLoader cl = context.getRuleContext().getKnowledgeBuilder().getRootClassLoader();
        for (int i = 2; i <= split.length; ++i) {
            String className = this.concatDotSeparated(split, 0, i);
            if (className.endsWith("!")) {
                className = className.substring(0, className.length() - 1);
            }
            if (ClassUtils.findClass((String)className, (ClassLoader)cl) == null) continue;
            return new String[]{className, this.concatDotSeparated(split, i, split.length)};
        }
        return null;
    }

    private String concatDotSeparated(String[] parts, int start, int end) {
        StringBuilder sb = new StringBuilder(parts[start]);
        for (int i = start + 1; i < end; ++i) {
            sb.append(".").append(parts[i]);
        }
        return sb.toString();
    }

    protected void processConnectiveDescr(StringBuilder sbuilder, BaseDescr base, int parentPriority, boolean isInsideRelCons, DumperContext context) {
        boolean wrapParenthesis;
        ConstraintConnectiveDescr ccd = (ConstraintConnectiveDescr)base;
        boolean bl = wrapParenthesis = parentPriority > ccd.getConnective().getPrecedence();
        if (wrapParenthesis) {
            sbuilder.append("( ");
        }
        boolean first = true;
        ArrayList descrs = new ArrayList(ccd.getDescrs());
        for (BaseDescr constr : descrs) {
            if (!(constr instanceof BindingDescr)) {
                if (first) {
                    first = false;
                } else {
                    sbuilder.append(" ");
                    sbuilder.append(ccd.getConnective().toString());
                    sbuilder.append(" ");
                }
            }
            context.incOpenCcd();
            this.dump(sbuilder, constr, ccd, ccd.getDescrs().indexOf(constr), ccd.getConnective().getPrecedence(), isInsideRelCons, context);
            context.decOpenCcd();
        }
        if (first) {
            sbuilder.append("true");
        }
        if (wrapParenthesis) {
            sbuilder.append(" )");
        }
    }

    @Override
    public String processRestriction(DumperContext context, String left, OperatorDescr operator, String right) {
        StringBuilder sbuilder = new StringBuilder();
        Operator op = Operator.determineOperator((String)operator.getOperator(), (boolean)operator.isNegated());
        if (op == Operator.determineOperator((String)"memberOf", (boolean)operator.isNegated())) {
            int lastAndPos = left.lastIndexOf("&&");
            if (lastAndPos > 0) {
                sbuilder.append(left.substring(0, lastAndPos).trim()).append(" && ");
                left = left.substring(lastAndPos + 2).trim();
            }
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(right).append(" contains ").append(left).append(this.evaluatorSufix(operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"contains", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" contains ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"excludes", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(!operator.isNegated())).append(left).append(" contains ").append(right).append(this.evaluatorSufix(!operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"matches", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" ~= ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else if (this.lookupBasicOperator(operator.getOperator())) {
            if (operator.getOperator().equals("instanceof")) {
                context.addInferredCast(left, right);
            }
            this.rewriteBasicOperator(sbuilder, left, operator, right);
        } else {
            this.rewriteOperator(context, sbuilder, left, operator, right);
        }
        return sbuilder.toString();
    }

    protected void rewriteBasicOperator(StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" ").append(operator.getOperator()).append(" ").append(right).append(this.evaluatorSufix(operator.isNegated()));
    }

    protected boolean lookupBasicOperator(String op) {
        return Arrays.binarySearch(standard, op) >= 0;
    }

    protected void rewriteOperator(DumperContext context, StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        String alias = context.createAlias(operator);
        operator.setLeftString(left);
        operator.setRightString(right);
        sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(alias).append(".evaluate( ").append(WM_ARGUMENT).append(", ").append(left).append(", ").append(right).append(" )").append(this.evaluatorSufix(operator.isNegated()));
    }

    protected String evaluatorPrefix(boolean isNegated) {
        if (isNegated) {
            return "!( ";
        }
        return "";
    }

    protected String evaluatorSufix(boolean isNegated) {
        if (isNegated) {
            return " )";
        }
        return "";
    }

    private DumperContext createContext() {
        return new DumperContext();
    }

    static {
        Arrays.sort(standard);
    }
}

