/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.util;

import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.rule.Pattern;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.OperatorDescr;
import org.drools.drl.ast.descr.RelationalExprDescr;
import org.drools.util.Config;

public class ConstraintUtil {
    public static final String DROOLS_NORMALIZE_CONSTRAINT = "drools.normalize.constraint";
    static boolean ENABLE_NORMALIZE = Boolean.parseBoolean(Config.getConfig((String)"drools.normalize.constraint", (String)"true"));

    private ConstraintUtil() {
    }

    public static String inverseExpression(RelationalExprDescr relDescr, String expression, String leftValue, String rightValue, String operator, Pattern pattern) {
        if (!ENABLE_NORMALIZE) {
            return expression;
        }
        String leftProp = ConstraintUtil.getFirstProp(leftValue);
        String rightProp = ConstraintUtil.getFirstProp(rightValue);
        OperatorDescr operatorDescr = relDescr.getOperatorDescr();
        if (ConstraintUtil.canInverse(pattern, operator, operatorDescr, leftProp, rightProp) && ConstraintUtil.isPropertyOnRight(pattern.getObjectType(), leftProp, rightProp)) {
            boolean negate = false;
            if (ConstraintUtil.isNegatedExpression(expression, leftValue, rightValue, operator)) {
                if (relDescr.getOperatorDescr().isNegated()) {
                    negate = true;
                } else {
                    return expression;
                }
            }
            BaseDescr left = relDescr.getLeft();
            relDescr.setLeft(relDescr.getRight());
            relDescr.setRight(left);
            String inversedOperator = ConstraintTypeOperator.decode((String)operator).inverse().getOperator();
            operatorDescr.setOperator(inversedOperator);
            String inversedExpression = rightValue + " " + inversedOperator + " " + leftValue;
            if (negate) {
                inversedExpression = "!( " + inversedExpression + " )";
            }
            return inversedExpression;
        }
        return expression;
    }

    private static boolean isPropertyOnRight(ObjectType objectType, String leftProp, String rightProp) {
        return !objectType.hasField(leftProp) && (objectType.hasField(rightProp) || "this".equals(rightProp));
    }

    private static boolean canInverse(Pattern pattern, String operator, OperatorDescr operatorDescr, String leftProp, String rightProp) {
        if (!(pattern.getObjectType() instanceof ClassObjectType)) {
            return false;
        }
        if (!operator.equals(operatorDescr.getOperator())) {
            return false;
        }
        if (leftProp.isEmpty() || rightProp.isEmpty()) {
            return false;
        }
        return ConstraintTypeOperator.decode((String)operator).canInverse();
    }

    private static String getFirstProp(String str) {
        int idxDot = str.indexOf(46);
        int idxBracket = str.indexOf(91);
        if (idxDot == -1 && idxBracket == -1) {
            return str;
        }
        if (idxDot != -1 && idxBracket != -1) {
            return str.substring(0, Math.min(idxDot, idxBracket));
        }
        return str.substring(0, Math.max(idxDot, idxBracket));
    }

    private static boolean isNegatedExpression(String expression, String leftValue, String rightValue, String operator) {
        return expression.matches("^!\\s*\\(\\s*\\Q" + leftValue + "\\E\\s*" + operator + "\\s*\\Q" + rightValue + "\\E\\s*\\)$");
    }
}

