/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.generator.StringDataGenerator;
import org.optaplanner.examples.taskassigning.domain.Affinity;
import org.optaplanner.examples.taskassigning.domain.Customer;
import org.optaplanner.examples.taskassigning.domain.Employee;
import org.optaplanner.examples.taskassigning.domain.Priority;
import org.optaplanner.examples.taskassigning.domain.Skill;
import org.optaplanner.examples.taskassigning.domain.Task;
import org.optaplanner.examples.taskassigning.domain.TaskAssigningSolution;
import org.optaplanner.examples.taskassigning.domain.TaskType;
import org.optaplanner.examples.taskassigning.persistence.TaskAssigningSolutionFileIO;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class TaskAssigningGenerator
extends LoggingMain {
    public static final int BASE_DURATION_MINIMUM = 30;
    public static final int BASE_DURATION_MAXIMUM = 90;
    public static final int BASE_DURATION_AVERAGE = 75;
    private static final int SKILL_SET_SIZE_MINIMUM = 2;
    private static final int SKILL_SET_SIZE_MAXIMUM = 4;
    private final StringDataGenerator skillNameGenerator = new StringDataGenerator().addPart(true, 0, "Problem", "Team", "Business", "Risk", "Creative", "Strategic", "Customer", "Conflict", "IT", "Academic").addPart(true, 1, "Solving", "Building", "Storytelling", "Management", "Thinking", "Planning", "Service", "Resolution", "Engineering", "Research");
    private final StringDataGenerator taskTypeNameGenerator = new StringDataGenerator().addPart(true, 0, "Improve", "Expand", "Shrink", "Approve", "Localize", "Review", "Clean", "Merge", "Double", "Optimize").addPart(true, 1, "Sales", "Tax", "VAT", "Legal", "Cloud", "Marketing", "IT", "Contract", "Financial", "Advertisement").addPart(false, 2, "Software", "Development", "Accounting", "Management", "Facilities", "Writing", "Productization", "Lobbying", "Engineering", "Research");
    private final StringDataGenerator customerNameGenerator = StringDataGenerator.buildCompanyNames();
    private final StringDataGenerator employeeNameGenerator = StringDataGenerator.buildFullNames();
    protected final SolutionFileIO<TaskAssigningSolution> solutionFileIO = new TaskAssigningSolutionFileIO();
    protected final File outputDir = new File(CommonApp.determineDataDir("taskassigning"), "unsolved");
    protected Random random;

    public static void main(String[] args) {
        TaskAssigningGenerator generator = new TaskAssigningGenerator();
        generator.writeTaskAssigningSolution(24, 8);
        generator.writeTaskAssigningSolution(50, 5);
        generator.writeTaskAssigningSolution(100, 5);
        generator.writeTaskAssigningSolution(500, 20);
    }

    private void writeTaskAssigningSolution(int taskListSize, int employeeListSize) {
        int skillListSize = 4 + (int)Math.log(employeeListSize);
        int taskTypeListSize = taskListSize / 5;
        int customerListSize = Math.min(taskTypeListSize, employeeListSize * 3);
        String fileName = this.determineFileName(taskListSize, employeeListSize);
        File outputFile = new File(this.outputDir, fileName + ".json");
        TaskAssigningSolution solution = this.createTaskAssigningSolution(fileName, taskListSize, skillListSize, employeeListSize, taskTypeListSize, customerListSize);
        this.solutionFileIO.write((Object)solution, outputFile);
        this.logger.info("Saved: {}", (Object)outputFile);
    }

    private String determineFileName(int taskListSize, int employeeListSize) {
        return taskListSize + "tasks-" + employeeListSize + "employees";
    }

    public TaskAssigningSolution createTaskAssigningSolution(String fileName, int taskListSize, int skillListSize, int employeeListSize, int taskTypeListSize, int customerListSize) {
        this.random = new Random(37L);
        TaskAssigningSolution solution = new TaskAssigningSolution(0L);
        this.createSkillList(solution, skillListSize);
        this.createCustomerList(solution, customerListSize);
        this.createEmployeeList(solution, employeeListSize);
        this.createTaskTypeList(solution, taskTypeListSize);
        this.createTaskList(solution, taskListSize);
        solution.setFrozenCutoff(0);
        BigInteger a = AbstractSolutionImporter.factorial(taskListSize + employeeListSize - 1);
        BigInteger b = AbstractSolutionImporter.factorial(employeeListSize - 1);
        BigInteger possibleSolutionSize = a == null || b == null ? null : a.divide(b);
        this.logger.info("TaskAssigningSolution {} has {} tasks, {} skills, {} employees, {} task types and {} customers with a search space of {}.", new Object[]{fileName, taskListSize, skillListSize, employeeListSize, taskTypeListSize, customerListSize, AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return solution;
    }

    private void createSkillList(TaskAssigningSolution solution, int skillListSize) {
        ArrayList<Skill> skillList = new ArrayList<Skill>(skillListSize);
        this.skillNameGenerator.predictMaximumSizeAndReset(skillListSize);
        for (int i = 0; i < skillListSize; ++i) {
            String skillName = this.skillNameGenerator.generateNextValue();
            Skill skill = new Skill(i, skillName);
            this.logger.trace("Created skill with skillName ({}).", (Object)skillName);
            skillList.add(skill);
        }
        solution.setSkillList(skillList);
    }

    private void createCustomerList(TaskAssigningSolution solution, int customerListSize) {
        ArrayList<Customer> customerList = new ArrayList<Customer>(customerListSize);
        this.customerNameGenerator.predictMaximumSizeAndReset(customerListSize);
        for (int i = 0; i < customerListSize; ++i) {
            String customerName = this.customerNameGenerator.generateNextValue();
            Customer customer = new Customer(i, customerName);
            this.logger.trace("Created skill with customerName ({}).", (Object)customerName);
            customerList.add(customer);
        }
        solution.setCustomerList(customerList);
    }

    private void createEmployeeList(TaskAssigningSolution solution, int employeeListSize) {
        List<Skill> skillList = solution.getSkillList();
        List<Customer> customerList = solution.getCustomerList();
        Affinity[] affinities = Affinity.values();
        ArrayList<Employee> employeeList = new ArrayList<Employee>(employeeListSize);
        int skillListIndex = 0;
        this.employeeNameGenerator.predictMaximumSizeAndReset(employeeListSize);
        for (int i = 0; i < employeeListSize; ++i) {
            String fullName = this.employeeNameGenerator.generateNextValue();
            Employee employee = new Employee(i, fullName);
            int skillSetSize = 2 + this.random.nextInt(2);
            if (skillSetSize > skillList.size()) {
                skillSetSize = skillList.size();
            }
            LinkedHashSet<Skill> skillSet = new LinkedHashSet<Skill>(skillSetSize);
            for (int j = 0; j < skillSetSize; ++j) {
                skillSet.add(skillList.get(skillListIndex));
                skillListIndex = (skillListIndex + 1) % skillList.size();
            }
            employee.setSkillSet(skillSet);
            LinkedHashMap<Customer, Affinity> affinityMap = new LinkedHashMap<Customer, Affinity>(customerList.size());
            for (Customer customer : customerList) {
                affinityMap.put(customer, affinities[this.random.nextInt(affinities.length)]);
            }
            employee.setAffinityMap(affinityMap);
            employee.setTasks(new ArrayList<Task>());
            this.logger.trace("Created employee with fullName ({}).", (Object)fullName);
            employeeList.add(employee);
        }
        solution.setEmployeeList(employeeList);
    }

    private void createTaskTypeList(TaskAssigningSolution solution, int taskTypeListSize) {
        List<Employee> employeeList = solution.getEmployeeList();
        ArrayList<TaskType> taskTypeList = new ArrayList<TaskType>(taskTypeListSize);
        LinkedHashSet<String> codeSet = new LinkedHashSet<String>(taskTypeListSize);
        this.taskTypeNameGenerator.predictMaximumSizeAndReset(taskTypeListSize);
        for (int i = 0; i < taskTypeListSize; ++i) {
            Object code;
            String title = this.taskTypeNameGenerator.generateNextValue();
            switch (title.replaceAll("[^ ]", "").length() + 1) {
                case 3: {
                    code = title.replaceAll("(\\w)\\w* (\\w)\\w* (\\w)\\w*", "$1$2$3");
                    break;
                }
                case 2: {
                    code = title.replaceAll("(\\w)\\w* (\\w)\\w*", "$1$2");
                    break;
                }
                case 1: {
                    code = title.replaceAll("(\\w)\\w*", "$1");
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot convert title (" + title + ") into a code.");
                }
            }
            if (codeSet.contains(code)) {
                int codeSuffixNumber = 1;
                while (codeSet.contains((String)code + codeSuffixNumber)) {
                    ++codeSuffixNumber;
                }
                code = (String)code + codeSuffixNumber;
            }
            codeSet.add((String)code);
            TaskType taskType = new TaskType(i, title, (String)code, 30 + this.random.nextInt(60));
            Employee randomEmployee = employeeList.get(this.random.nextInt(employeeList.size()));
            ArrayList<Skill> randomSkillList = new ArrayList<Skill>(randomEmployee.getSkillSet());
            Collections.shuffle(randomSkillList, this.random);
            int requiredSkillListSize = 1 + this.random.nextInt(randomSkillList.size() - 1);
            taskType.setRequiredSkillList(new ArrayList<Skill>(randomSkillList.subList(0, requiredSkillListSize)));
            this.logger.trace("Created taskType with title ({}).", (Object)title);
            taskTypeList.add(taskType);
        }
        solution.setTaskTypeList(taskTypeList);
    }

    private void createTaskList(TaskAssigningSolution solution, int taskListSize) {
        List<TaskType> taskTypeList = solution.getTaskTypeList();
        List<Customer> customerList = solution.getCustomerList();
        Priority[] priorities = Priority.values();
        ArrayList<Task> taskList = new ArrayList<Task>(taskListSize);
        LinkedHashMap<TaskType, Integer> maxIndexInTaskTypeMap = new LinkedHashMap<TaskType, Integer>(taskTypeList.size());
        for (int i = 0; i < taskListSize; ++i) {
            TaskType taskType = taskTypeList.get(this.random.nextInt(taskTypeList.size()));
            Integer indexInTaskType = (Integer)maxIndexInTaskTypeMap.get(taskType);
            if (indexInTaskType == null) {
                indexInTaskType = 1;
            } else {
                Integer n = indexInTaskType;
                indexInTaskType = indexInTaskType + 1;
            }
            maxIndexInTaskTypeMap.put(taskType, indexInTaskType);
            Task task = new Task(i, taskType, indexInTaskType, customerList.get(this.random.nextInt(customerList.size())), 0, priorities[this.random.nextInt(priorities.length)]);
            taskList.add(task);
        }
        solution.setTaskList(taskList);
    }
}

