/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementRef;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.solver.random.RandomUtils;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class ElementDestinationSelector<Solution_>
extends AbstractSelector<Solution_>
implements DestinationSelector<Solution_> {
    private final EntitySelector<Solution_> entitySelector;
    private final EntityIndependentValueSelector<Solution_> valueSelector;
    private final boolean randomSelection;
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public ElementDestinationSelector(EntitySelector<Solution_> entitySelector, EntityIndependentValueSelector<Solution_> valueSelector, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)this.valueSelector.getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand(listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand(listVariableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public long getSize() {
        if (this.entitySelector.getSize() == 0L) {
            return 0L;
        }
        return this.entitySelector.getSize() + this.valueSelector.getSize();
    }

    @Override
    public Iterator<ElementRef> iterator() {
        if (this.randomSelection) {
            final long totalSize = Math.addExact(this.entitySelector.getSize(), this.valueSelector.getSize());
            final Iterator entityIterator = this.entitySelector.iterator();
            final Iterator valueIterator = this.valueSelector.iterator();
            return new Iterator<ElementRef>(){

                @Override
                public boolean hasNext() {
                    return entityIterator.hasNext();
                }

                @Override
                public ElementRef next() {
                    long entitySize = ElementDestinationSelector.this.entitySelector.getSize();
                    if (RandomUtils.nextLong(ElementDestinationSelector.this.workingRandom, totalSize) < entitySize) {
                        return ElementRef.of(entityIterator.next(), 0);
                    }
                    Object value = valueIterator.next();
                    return ElementRef.of(ElementDestinationSelector.this.inverseVariableSupply.getInverseSingleton(value), ElementDestinationSelector.this.indexVariableSupply.getIndex(value) + 1);
                }
            };
        }
        if (this.entitySelector.getSize() == 0L) {
            return Collections.emptyIterator();
        }
        return Stream.concat(StreamSupport.stream(this.entitySelector.spliterator(), false).map(entity -> ElementRef.of(entity, 0)), StreamSupport.stream(this.valueSelector.spliterator(), false).map(value -> ElementRef.of(this.inverseVariableSupply.getInverseSingleton(value), this.indexVariableSupply.getIndex(value) + 1))).iterator();
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    public ListVariableDescriptor<Solution_> getVariableDescriptor() {
        return (ListVariableDescriptor)this.valueSelector.getVariableDescriptor();
    }

    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.entitySelector.getEntityDescriptor();
    }

    public Iterator<Object> endingIterator() {
        return Stream.concat(StreamSupport.stream(Spliterators.spliterator(this.entitySelector.endingIterator(), this.entitySelector.getSize(), 0), false), StreamSupport.stream(Spliterators.spliterator(this.valueSelector.endingIterator(null), this.valueSelector.getSize(), 0), false)).iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementDestinationSelector that = (ElementDestinationSelector)o;
        return this.randomSelection == that.randomSelection && Objects.equals(this.entitySelector, that.entitySelector) && Objects.equals(this.valueSelector, that.valueSelector);
    }

    public int hashCode() {
        return Objects.hash(this.entitySelector, this.valueSelector, this.randomSelection);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }
}

