/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;

public interface JavaCompiler {
    public static final boolean DUMP_GENERATED_CLASSES = false;

    public static JavaCompiler getCompiler() {
        return CompilerHolder.JAVA_COMPILER;
    }

    public static JavaCompiler createNativeCompiler() {
        return JavaCompiler.createNativeCompiler(System.getProperty("java.version"));
    }

    public static JavaCompiler createNativeCompiler(String javaVersion) {
        return JavaCompilerFactory.loadCompiler(JavaConfiguration.CompilerType.NATIVE, javaVersion, "src/main/java/");
    }

    public static JavaCompiler createEclipseCompiler() {
        return JavaCompiler.createEclipseCompiler(System.getProperty("java.version"));
    }

    public static JavaCompiler createEclipseCompiler(String javaVersion) {
        return JavaCompilerFactory.loadCompiler(JavaConfiguration.CompilerType.ECLIPSE, javaVersion, "src/main/java/");
    }

    default public void setSourceFolder(String sourceFolder) {
    }

    public JavaCompilerSettings createDefaultSettings();

    public void setJavaCompilerSettings(JavaCompilerSettings var1);

    public CompilationResult compile(String[] var1, ResourceReader var2, ResourceStore var3);

    public CompilationResult compile(String[] var1, ResourceReader var2, ResourceStore var3, ClassLoader var4);

    public CompilationResult compile(String[] var1, ResourceReader var2, ResourceStore var3, ClassLoader var4, JavaCompilerSettings var5);

    public static class CompilerHolder {
        private static final JavaCompiler JAVA_COMPILER = System.getProperty("jboss.server.name") != null ? JavaCompiler.createEclipseCompiler() : JavaCompiler.createNativeCompiler();
    }
}

