/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simplelong;

import org.optaplanner.core.api.score.AbstractScore;

public final class SimpleLongScore
extends AbstractScore<SimpleLongScore> {
    private final long score;

    public static SimpleLongScore parseScore(String scoreString) {
        return SimpleLongScore.valueOf(Long.parseLong(scoreString));
    }

    public static SimpleLongScore valueOf(long score) {
        return new SimpleLongScore(score);
    }

    private SimpleLongScore(long score) {
        this.score = score;
    }

    public long getScore() {
        return this.score;
    }

    @Override
    public SimpleLongScore add(SimpleLongScore augment) {
        return new SimpleLongScore(this.score + augment.getScore());
    }

    @Override
    public SimpleLongScore subtract(SimpleLongScore subtrahend) {
        return new SimpleLongScore(this.score - subtrahend.getScore());
    }

    @Override
    public SimpleLongScore multiply(double multiplicand) {
        return new SimpleLongScore((long)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleLongScore divide(double divisor) {
        return new SimpleLongScore((long)Math.floor((double)this.score / divisor));
    }

    @Override
    public double[] toDoubleLevels() {
        return new double[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleLongScore) {
            SimpleLongScore other = (SimpleLongScore)o;
            return this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return 629 + Long.valueOf(this.score).hashCode();
    }

    @Override
    public int compareTo(SimpleLongScore other) {
        if (this.score < other.getScore()) {
            return -1;
        }
        if (this.score > other.getScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Long.toString(this.score);
    }
}

