/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint.primint;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primint.IntConstraintMatch;

public class IntConstraintMatchTotal
extends ConstraintMatchTotal {
    protected final Set<IntConstraintMatch> constraintMatchSet = new HashSet<IntConstraintMatch>();
    protected int weightTotal = 0;

    public IntConstraintMatchTotal(String constraintPackage, String constraintName, int scoreLevel) {
        super(constraintPackage, constraintName, scoreLevel);
    }

    public Set<IntConstraintMatch> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    public int getWeightTotal() {
        return this.weightTotal;
    }

    @Override
    public Number getWeightTotalAsNumber() {
        return this.weightTotal;
    }

    public IntConstraintMatch addConstraintMatch(RuleContext kcontext, int weight) {
        this.weightTotal += weight;
        List<Object> justificationList = this.extractJustificationList(kcontext);
        IntConstraintMatch constraintMatch = new IntConstraintMatch(this, justificationList, weight);
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        return constraintMatch;
    }

    public void removeConstraintMatch(IntConstraintMatch constraintMatch) {
        this.weightTotal -= constraintMatch.getWeight();
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }
}

