/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.constructionheuristic.placer.entity;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.config.constructionheuristic.placer.entity.EntityPlacerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.value.ValuePlacerConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.constructionheuristic.placer.entity.QueuedEntityPlacer;
import org.optaplanner.core.impl.constructionheuristic.placer.value.ValuePlacer;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.termination.Termination;

@XStreamAlias(value="queuedEntityPlacer")
public class QueuedEntityPlacerConfig
extends EntityPlacerConfig {
    @XStreamAlias(value="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = null;
    @XStreamImplicit(itemFieldName="valuePlacer")
    protected List<ValuePlacerConfig> valuePlacerConfigList = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public List<ValuePlacerConfig> getValuePlacerConfigList() {
        return this.valuePlacerConfigList;
    }

    public void setValuePlacerConfigList(List<ValuePlacerConfig> valuePlacerConfigList) {
        this.valuePlacerConfigList = valuePlacerConfigList;
    }

    @Override
    public QueuedEntityPlacer buildEntityPlacer(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, Termination phaseTermination) {
        EntitySelectorConfig entitySelectorConfig_ = this.entitySelectorConfig == null ? new EntitySelectorConfig() : this.entitySelectorConfig;
        EntitySelector entitySelector = entitySelectorConfig_.buildEntitySelector(environmentMode, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.ORIGINAL);
        List<ValuePlacerConfig> valuePlacerConfigList_ = this.valuePlacerConfigList == null ? Arrays.asList(new ValuePlacerConfig()) : this.valuePlacerConfigList;
        ArrayList<ValuePlacer> valuePlacerList = new ArrayList<ValuePlacer>(valuePlacerConfigList_.size());
        for (ValuePlacerConfig valuePlacerConfig : valuePlacerConfigList_) {
            valuePlacerList.add(valuePlacerConfig.buildValuePlacer(environmentMode, solutionDescriptor, phaseTermination, entitySelector.getEntityDescriptor()));
        }
        return new QueuedEntityPlacer(entitySelector, valuePlacerList);
    }

    public void inherit(QueuedEntityPlacerConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.entitySelectorConfig == null) {
            this.entitySelectorConfig = inheritedConfig.getEntitySelectorConfig();
        } else if (inheritedConfig.getEntitySelectorConfig() != null) {
            this.entitySelectorConfig.inherit(inheritedConfig.getEntitySelectorConfig());
        }
        this.valuePlacerConfigList = ConfigUtils.inheritMergeableListProperty(this.valuePlacerConfigList, inheritedConfig.getValuePlacerConfigList());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ", " + this.valuePlacerConfigList + ")";
    }
}

