/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.util;

import java.util.ArrayList;
import java.util.List;

public class ConfigUtils {
    public static <T> T newInstance(Object bean, String propertyName, Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("The " + bean.getClass().getSimpleName() + "'s " + propertyName + " (" + clazz.getName() + ") does not have a public no-arg constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The " + bean.getClass().getSimpleName() + "'s " + propertyName + " (" + clazz.getName() + ") does not have a public no-arg constructor", e);
        }
    }

    public static <T> T inheritOverwritableProperty(T original, T inherited) {
        if (original != null) {
            return original;
        }
        return inherited;
    }

    public static <T> List<T> inheritMergeableListProperty(List<T> originalList, List<T> inheritedList) {
        if (inheritedList == null) {
            return originalList;
        }
        if (originalList == null) {
            return inheritedList;
        }
        ArrayList<T> mergedList = new ArrayList<T>(inheritedList);
        mergedList.addAll(originalList);
        return mergedList;
    }

    private ConfigUtils() {
    }
}

