/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.entity;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.PlanningEntitySorter;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.solution.Solution;

public class PlanningEntityDescriptor {
    private final SolutionDescriptor solutionDescriptor;
    private final Class<?> planningEntityClass;
    private final BeanInfo planningEntityBeanInfo;
    private SelectionFilter movableEntitySelectionFilter;
    private PlanningEntitySorter planningEntitySorter;
    private Map<String, PlanningVariableDescriptor> planningVariableDescriptorMap;

    public PlanningEntityDescriptor(SolutionDescriptor solutionDescriptor, Class<?> planningEntityClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.planningEntityClass = planningEntityClass;
        try {
            this.planningEntityBeanInfo = Introspector.getBeanInfo(planningEntityClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The planningEntityClass (" + planningEntityClass + ") is not a valid java bean.", e);
        }
    }

    public void processAnnotations() {
        this.processEntityAnnotations();
        this.processPropertyAnnotations();
    }

    private void processEntityAnnotations() {
        PlanningEntity entityAnnotation = this.planningEntityClass.getAnnotation(PlanningEntity.class);
        if (entityAnnotation == null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") has been specified as a planning entity in the configuration," + " but does not have a " + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        this.processMovable(entityAnnotation);
        this.planningEntitySorter = new PlanningEntitySorter();
        this.processDifficulty(entityAnnotation);
    }

    private void processMovable(PlanningEntity entityAnnotation) {
        Class<? extends SelectionFilter> movableEntitySelectionFilterClass = entityAnnotation.movableEntitySelectionFilter();
        if (movableEntitySelectionFilterClass == PlanningEntity.NullMovableEntitySelectionFilter.class) {
            movableEntitySelectionFilterClass = null;
        }
        if (movableEntitySelectionFilterClass != null) {
            this.movableEntitySelectionFilter = ConfigUtils.newInstance(this, "movableEntitySelectionFilterClass", movableEntitySelectionFilterClass);
        }
    }

    private void processDifficulty(PlanningEntity entityAnnotation) {
        Class<? extends SelectionSorterWeightFactory> difficultyWeightFactoryClass;
        Class<? extends Comparator> difficultyComparatorClass = entityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass == PlanningEntity.NullDifficultyComparator.class) {
            difficultyComparatorClass = null;
        }
        if ((difficultyWeightFactoryClass = entityAnnotation.difficultyWeightFactoryClass()) == PlanningEntity.NullDifficultyWeightFactory.class) {
            difficultyWeightFactoryClass = null;
        }
        if (difficultyComparatorClass != null && difficultyWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") cannot have a difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") and a difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") at the same time.");
        }
        if (difficultyComparatorClass != null) {
            Comparator difficultyComparator = ConfigUtils.newInstance(this, "difficultyComparatorClass", difficultyComparatorClass);
            this.planningEntitySorter.setDifficultyComparator(difficultyComparator);
        }
        if (difficultyWeightFactoryClass != null) {
            SelectionSorterWeightFactory difficultyWeightFactory = ConfigUtils.newInstance(this, "difficultyWeightFactoryClass", difficultyWeightFactoryClass);
            this.planningEntitySorter.setDifficultyWeightFactory(difficultyWeightFactory);
        }
    }

    private void processPropertyAnnotations() {
        PropertyDescriptor[] propertyDescriptors = this.planningEntityBeanInfo.getPropertyDescriptors();
        this.planningVariableDescriptorMap = new LinkedHashMap<String, PlanningVariableDescriptor>(propertyDescriptors.length);
        boolean noPlanningVariableAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Method propertyGetter = propertyDescriptor.getReadMethod();
            if (propertyGetter == null || !propertyGetter.isAnnotationPresent(PlanningVariable.class)) continue;
            noPlanningVariableAnnotation = false;
            if (propertyDescriptor.getWriteMethod() == null) {
                throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") has a PlanningVariable annotated property (" + propertyDescriptor.getName() + ") that should have a setter.");
            }
            PlanningVariableDescriptor variableDescriptor = new PlanningVariableDescriptor(this, propertyDescriptor);
            this.planningVariableDescriptorMap.put(propertyDescriptor.getName(), variableDescriptor);
            variableDescriptor.processAnnotations();
        }
        if (noPlanningVariableAnnotation) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") should have at least 1 getter with a PlanningVariable annotation.");
        }
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getPlanningEntityClass() {
        return this.planningEntityClass;
    }

    public boolean appliesToPlanningEntity(Object entity) {
        return entity.getClass().isAssignableFrom(this.planningEntityClass);
    }

    public boolean hasMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter != null;
    }

    public SelectionFilter getMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter;
    }

    public PlanningEntitySorter getPlanningEntitySorter() {
        return this.planningEntitySorter;
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        for (PropertyDescriptor propertyDescriptor : this.planningEntityBeanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public Collection<String> getPlanningVariableNameSet() {
        return this.planningVariableDescriptorMap.keySet();
    }

    public Collection<PlanningVariableDescriptor> getPlanningVariableDescriptors() {
        return this.planningVariableDescriptorMap.values();
    }

    public PlanningVariableDescriptor getPlanningVariableDescriptor(String propertyName) {
        return this.planningVariableDescriptorMap.get(propertyName);
    }

    public List<Object> extractEntities(Solution solution) {
        return this.solutionDescriptor.getPlanningEntityListByPlanningEntityClass(solution, this.planningEntityClass);
    }

    public long getProblemScale(Solution solution, Object planningEntity) {
        long problemScale = 1L;
        for (PlanningVariableDescriptor variableDescriptor : this.planningVariableDescriptorMap.values()) {
            problemScale *= variableDescriptor.getProblemScale(solution, planningEntity);
        }
        return problemScale;
    }

    public int countUninitializedVariables(Object planningEntity) {
        int uninitializedVariableCount = 0;
        for (PlanningVariableDescriptor variableDescriptor : this.planningVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(planningEntity)) continue;
            ++uninitializedVariableCount;
        }
        return uninitializedVariableCount;
    }

    public boolean isInitialized(Object planningEntity) {
        for (PlanningVariableDescriptor variableDescriptor : this.planningVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(planningEntity)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.planningEntityClass.getName() + ")";
    }
}

