/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.solver.move;

import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.Room;

public class ExaminationMoveHelper {
    public static void movePeriod(ScoreDirector scoreDirector, Exam exam, Period period) {
        scoreDirector.beforeVariableChanged(exam, "period");
        exam.setPeriod(period);
        scoreDirector.afterVariableChanged(exam, "period");
        ExaminationMoveHelper.movePeriodCoincidence(scoreDirector, exam, period);
    }

    public static void moveRoom(ScoreDirector scoreDirector, Exam exam, Room room) {
        scoreDirector.beforeVariableChanged(exam, "room");
        exam.setRoom(room);
        scoreDirector.afterVariableChanged(exam, "room");
    }

    public static void moveExam(ScoreDirector scoreDirector, Exam exam, Period period, Room room) {
        scoreDirector.beforeAllVariablesChanged(exam);
        exam.setPeriod(period);
        exam.setRoom(room);
        scoreDirector.afterAllVariablesChanged(exam);
        ExaminationMoveHelper.movePeriodCoincidence(scoreDirector, exam, period);
    }

    public static void movePeriodCoincidence(ScoreDirector scoreDirector, Exam exam, Period period) {
        if (exam.getExamCoincidence() != null) {
            for (Exam coincidenceExam : exam.getExamCoincidence().getCoincidenceExamSet()) {
                if (exam.equals(coincidenceExam)) continue;
                scoreDirector.beforeVariableChanged(coincidenceExam, "period");
                coincidenceExam.setPeriod(period);
                scoreDirector.afterVariableChanged(coincidenceExam, "period");
            }
        }
    }

    private ExaminationMoveHelper() {
    }
}

