/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.machinereassignment.persistence;

import java.io.IOException;
import java.util.List;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.machinereassignment.domain.MachineReassignment;
import org.optaplanner.examples.machinereassignment.domain.MrMachine;
import org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment;
import org.optaplanner.examples.machinereassignment.persistence.MachineReassignmentDaoImpl;

public class MachineReassignmentSolutionExporter
extends AbstractTxtSolutionExporter {
    public static void main(String[] args) {
        new MachineReassignmentSolutionExporter().convertAll();
    }

    public MachineReassignmentSolutionExporter() {
        super(new MachineReassignmentDaoImpl());
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new MachineReassignmentOutputBuilder();
    }

    public class MachineReassignmentOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private MachineReassignment machineReassignment;

        public MachineReassignmentOutputBuilder() {
            super(MachineReassignmentSolutionExporter.this);
        }

        @Override
        public void setSolution(Solution solution) {
            this.machineReassignment = (MachineReassignment)solution;
        }

        @Override
        public void writeSolution() throws IOException {
            boolean first = true;
            List<MrMachine> machineList = this.machineReassignment.getMachineList();
            for (MrProcessAssignment processAssignment : this.machineReassignment.getProcessAssignmentList()) {
                if (first) {
                    first = false;
                } else {
                    this.bufferedWriter.write(" ");
                }
                this.bufferedWriter.write(Integer.toString(machineList.indexOf(processAssignment.getMachine())));
            }
        }
    }
}

