/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.SolutionDao;
import org.optaplanner.examples.nqueens.domain.Column;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;
import org.optaplanner.examples.nqueens.persistence.NQueensDaoImpl;

public class NQueensGenerator
extends LoggingMain {
    private static final File outputDir = new File("data/nqueens/unsolved/");
    protected SolutionDao solutionDao;

    public static void main(String[] args) {
        new NQueensGenerator().generate();
    }

    public void generate() {
        this.solutionDao = new NQueensDaoImpl();
        this.writeNQueens(4);
        this.writeNQueens(8);
        this.writeNQueens(16);
        this.writeNQueens(32);
        this.writeNQueens(64);
        this.writeNQueens(256);
    }

    private void writeNQueens(int n) {
        String outputFileName = "unsolvedNQueens" + (n < 10 ? "0" : "") + n + ".xml";
        File outputFile = new File(outputDir, outputFileName);
        NQueens nQueens = this.createNQueens(n);
        this.solutionDao.writeSolution(nQueens, outputFile);
    }

    public NQueens createNQueens(int n) {
        NQueens nQueens = new NQueens();
        nQueens.setId(0L);
        nQueens.setN(n);
        nQueens.setColumnList(this.createColumnList(nQueens));
        nQueens.setRowList(this.createRowList(nQueens));
        nQueens.setQueenList(this.createQueenList(nQueens));
        BigInteger possibleSolutionSize = BigInteger.valueOf(nQueens.getN()).pow(nQueens.getN());
        String flooredPossibleSolutionSize = "10^" + (possibleSolutionSize.toString().length() - 1);
        this.logger.info("NQueens {} has {} queens with a search space of {}.", new Object[]{n, nQueens.getN(), possibleSolutionSize.compareTo(BigInteger.valueOf(1000L)) < 0 ? possibleSolutionSize : flooredPossibleSolutionSize});
        return nQueens;
    }

    private List<Column> createColumnList(NQueens nQueens) {
        int n = nQueens.getN();
        ArrayList<Column> columnList = new ArrayList<Column>(n);
        for (int i = 0; i < n; ++i) {
            Column column = new Column();
            column.setId(Long.valueOf(i));
            column.setIndex(i);
            columnList.add(column);
        }
        return columnList;
    }

    private List<Row> createRowList(NQueens nQueens) {
        int n = nQueens.getN();
        ArrayList<Row> rowList = new ArrayList<Row>(n);
        for (int i = 0; i < n; ++i) {
            Row row = new Row();
            row.setId(Long.valueOf(i));
            row.setIndex(i);
            rowList.add(row);
        }
        return rowList;
    }

    private List<Queen> createQueenList(NQueens nQueens) {
        int n = nQueens.getN();
        ArrayList<Queen> queenList = new ArrayList<Queen>(n);
        long id = 0L;
        for (Column column : nQueens.getColumnList()) {
            Queen queen = new Queen();
            queen.setId(id);
            ++id;
            queen.setColumn(column);
            queenList.add(queen);
        }
        return queenList;
    }
}

