/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.AbstractKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.ClassUtils;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.internal.utils.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieModuleKieProject
extends AbstractKieProject {
    private static final Logger log = LoggerFactory.getLogger(KieModuleKieProject.class);
    private Map<ReleaseId, InternalKieModule> kieModules;
    private final Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private final InternalKieModule kieModule;
    private final KieRepository kr;
    private final CompositeClassLoader cl;

    public KieModuleKieProject(InternalKieModule kieModule, KieRepository kr) {
        this.kieModule = kieModule;
        this.kr = kr;
        this.cl = ClassLoaderUtil.getClassLoader(null, null, (boolean)true);
    }

    @Override
    public void init() {
        if (this.kieModules == null) {
            this.kieModules = new HashMap<ReleaseId, InternalKieModule>();
            this.kieModules.putAll(this.kieModule.getDependencies());
            this.kieModules.put(this.kieModule.getReleaseId(), this.kieModule);
            this.indexParts(this.kieModules, this.kJarFromKBaseName);
            this.initClassLoader();
        }
    }

    private void initClassLoader() {
        Map<String, byte[]> classes = this.getClassesMap();
        if (!classes.isEmpty()) {
            this.cl.addClassLoaderToEnd((ClassLoader)new ClassUtils.MapClassLoader(classes, (ClassLoader)this.cl));
        }
    }

    private Map<String, byte[]> getClassesMap() {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (InternalKieModule kModule : this.kieModules.values()) {
            classes.putAll(kModule.getClassesMap());
        }
        return classes;
    }

    @Override
    public ReleaseId getGAV() {
        return this.kieModule.getReleaseId();
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    public boolean kieBaseExists(String kBaseName) {
        return this.kBaseModels.containsKey(kBaseName);
    }

    @Override
    public CompositeClassLoader getClassLoader() {
        return this.cl;
    }
}

