/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.AfterEvaluatorDefinition;
import org.drools.core.base.evaluators.BeforeEvaluatorDefinition;
import org.drools.core.base.evaluators.MeetsEvaluatorDefinition;
import org.drools.core.base.evaluators.MetByEvaluatorDefinition;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.InternalReadAccessor;

public class VariableRestriction {
    private VariableRestriction() {
    }

    public static VariableContextEntry createContextEntry(InternalReadAccessor fieldExtractor, Declaration declaration, Evaluator evaluator) {
        ValueType coerced = evaluator.getCoercedValueType();
        if (evaluator.isTemporal()) {
            if (evaluator instanceof BeforeEvaluatorDefinition.BeforeEvaluator || evaluator instanceof MeetsEvaluatorDefinition.MeetsEvaluator) {
                return new LeftStartRightEndContextEntry(fieldExtractor, declaration, evaluator);
            }
            if (evaluator instanceof AfterEvaluatorDefinition.AfterEvaluator || evaluator instanceof MetByEvaluatorDefinition.MetByEvaluator) {
                return new LeftEndRightStartContextEntry(fieldExtractor, declaration, evaluator);
            }
            return new TemporalVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        if (coerced.isBoolean()) {
            return new BooleanVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        if (coerced.isFloatNumber()) {
            return new DoubleVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        if (coerced.isIntegerNumber() || coerced.isEvent()) {
            return new LongVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        if (coerced.isChar()) {
            return new CharVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        return new ObjectVariableContextEntry(fieldExtractor, declaration, evaluator);
    }

    public static class TemporalVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public long startTS;
        public long endTS;

        public TemporalVariableContextEntry() {
        }

        public TemporalVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startTS = in.readLong();
            this.endTS = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startTS);
            out.writeLong(this.startTS);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            if (this.declaration.getExtractor().isSelfReference()) {
                this.startTS = ((EventFactHandle)tuple.get(this.declaration)).getStartTimestamp();
                this.endTS = ((EventFactHandle)tuple.get(this.declaration)).getEndTimestamp();
            } else {
                this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
                this.startTS = !this.leftNull ? this.declaration.getExtractor().getLongValue(workingMemory, tuple.get(this.declaration).getObject()) : 0L;
                this.endTS = this.startTS;
            }
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            if (this.extractor.isSelfReference()) {
                this.startTS = ((EventFactHandle)handle).getStartTimestamp();
                this.endTS = ((EventFactHandle)handle).getEndTimestamp();
            } else {
                this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
                this.startTS = !this.rightNull ? this.extractor.getLongValue(workingMemory, handle.getObject()) : 0L;
                this.endTS = this.startTS;
            }
        }
    }

    public static class LeftEndRightStartContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public long timestamp;

        public LeftEndRightStartContextEntry() {
        }

        public LeftEndRightStartContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.timestamp = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.timestamp);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            if (this.declaration.getExtractor().isSelfReference()) {
                this.timestamp = ((EventFactHandle)tuple.get(this.declaration)).getEndTimestamp();
            } else {
                this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
                this.timestamp = !this.leftNull ? this.declaration.getExtractor().getLongValue(workingMemory, tuple.get(this.declaration).getObject()) : 0L;
            }
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            if (this.extractor.isSelfReference()) {
                this.timestamp = ((EventFactHandle)handle).getStartTimestamp();
            } else {
                this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
                this.timestamp = !this.rightNull ? this.extractor.getLongValue(workingMemory, handle.getObject()) : 0L;
            }
        }
    }

    public static class LeftStartRightEndContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public long timestamp;

        public LeftStartRightEndContextEntry() {
        }

        public LeftStartRightEndContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.timestamp = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.timestamp);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            if (this.declaration.getExtractor().isSelfReference()) {
                this.timestamp = ((EventFactHandle)tuple.get(this.declaration)).getStartTimestamp();
            } else {
                this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
                this.timestamp = !this.leftNull ? this.declaration.getExtractor().getLongValue(workingMemory, tuple.get(this.declaration).getObject()) : 0L;
            }
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            if (this.extractor.isSelfReference()) {
                this.timestamp = ((EventFactHandle)handle).getEndTimestamp();
            } else {
                this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
                this.timestamp = !this.rightNull ? this.extractor.getLongValue(workingMemory, handle.getObject()) : 0L;
            }
        }
    }

    public static class BooleanVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public boolean left;
        public boolean right;

        public BooleanVariableContextEntry() {
        }

        public BooleanVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readBoolean();
            this.right = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeBoolean(this.left);
            out.writeBoolean(this.right);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = !this.leftNull ? this.declaration.getExtractor().getBooleanValue(workingMemory, tuple.get(this.declaration).getObject()) : false;
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getBooleanValue(workingMemory, handle.getObject()) : false;
        }
    }

    public static class DoubleVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public double left;
        public double right;

        public DoubleVariableContextEntry() {
        }

        public DoubleVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readDouble();
            this.right = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeDouble(this.left);
            out.writeDouble(this.right);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = !this.leftNull ? this.declaration.getExtractor().getDoubleValue(workingMemory, tuple.get(this.declaration).getObject()) : 0.0;
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getDoubleValue(workingMemory, handle.getObject()) : 0.0;
        }
    }

    public static class CharVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public char left;
        public char right;

        public CharVariableContextEntry() {
        }

        public CharVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readChar();
            this.right = in.readChar();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeChar(this.left);
            out.writeChar(this.right);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = !this.leftNull ? this.declaration.getExtractor().getCharValue(workingMemory, tuple.get(this.declaration).getObject()) : (char)'\u0000';
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getCharValue(workingMemory, handle.getObject()) : (char)'\u0000';
        }
    }

    public static class LongVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public long left;
        public long right;

        public LongVariableContextEntry() {
        }

        public LongVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readLong();
            this.right = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.left);
            out.writeLong(this.right);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = !this.leftNull ? this.declaration.getExtractor().getLongValue(workingMemory, tuple.get(this.declaration).getObject()) : 0L;
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getLongValue(workingMemory, handle.getObject()) : 0L;
        }
    }

    public static class PrimitiveArrayVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public Object left;
        public Object right;

        public PrimitiveArrayVariableContextEntry() {
        }

        public PrimitiveArrayVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readObject();
            this.right = in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.left);
            out.writeObject(this.right);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = this.declaration.getExtractor().getValue(workingMemory, tuple.get(this.declaration).getObject());
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = this.extractor.getValue(workingMemory, handle.getObject());
        }

        @Override
        public void resetTuple() {
            this.left = null;
            this.reteTuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.right = null;
            this.object = null;
        }
    }

    public static class ObjectVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public Object left;
        public Object right;

        public ObjectVariableContextEntry() {
        }

        public ObjectVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readObject();
            this.right = in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.left);
            out.writeObject(this.right);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, tuple.get(this.declaration).getObject());
            this.left = this.declaration.getExtractor().getValue(workingMemory, tuple.get(this.declaration).getObject());
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, handle.getObject());
            this.right = this.extractor.getValue(workingMemory, handle.getObject());
        }

        @Override
        public void resetTuple() {
            this.left = null;
            this.reteTuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.right = null;
            this.object = null;
        }
    }

    public static abstract class VariableContextEntry
    implements ContextEntry {
        public InternalReadAccessor extractor;
        public Evaluator evaluator;
        public Object object;
        public Declaration declaration;
        public LeftTuple reteTuple;
        public ContextEntry entry;
        public boolean leftNull;
        public boolean rightNull;
        public InternalWorkingMemory workingMemory;

        public VariableContextEntry() {
        }

        public VariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            this.extractor = extractor;
            this.declaration = declaration;
            this.evaluator = evaluator;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.workingMemory = (InternalWorkingMemory)in.readObject();
            this.extractor = (InternalReadAccessor)in.readObject();
            this.evaluator = (Evaluator)in.readObject();
            this.object = in.readObject();
            this.declaration = (Declaration)in.readObject();
            this.reteTuple = (LeftTuple)in.readObject();
            this.entry = (ContextEntry)in.readObject();
            this.leftNull = in.readBoolean();
            this.rightNull = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.workingMemory);
            out.writeObject(this.extractor);
            out.writeObject(this.evaluator);
            out.writeObject(this.object);
            out.writeObject(this.declaration);
            out.writeObject(this.reteTuple);
            out.writeObject(this.entry);
            out.writeBoolean(this.leftNull);
            out.writeBoolean(this.rightNull);
        }

        @Override
        public ContextEntry getNext() {
            return this.entry;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.extractor;
        }

        public Object getObject() {
            return this.object;
        }

        public LeftTuple getTuple() {
            return this.reteTuple;
        }

        public Declaration getVariableDeclaration() {
            return this.declaration;
        }

        public boolean isLeftNull() {
            return this.leftNull;
        }

        public boolean isRightNull() {
            return this.rightNull;
        }

        @Override
        public void resetTuple() {
            this.reteTuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.object = null;
        }
    }
}

