/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.move.composite;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.composite.CartesianProductMoveSelector;

@XStreamAlias(value="cartesianProductMoveSelector")
public class CartesianProductMoveSelectorConfig
extends MoveSelectorConfig {
    @XStreamImplicit
    private List<MoveSelectorConfig> moveSelectorConfigList = null;

    public List<MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    @Override
    public MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ArrayList<MoveSelector> moveSelectorList = new ArrayList<MoveSelector>(this.moveSelectorConfigList.size());
        for (MoveSelectorConfig moveSelectorConfig : this.moveSelectorConfigList) {
            moveSelectorList.add(moveSelectorConfig.buildMoveSelector(environmentMode, solutionDescriptor, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection)));
        }
        return new CartesianProductMoveSelector(moveSelectorList, randomSelection);
    }

    public void inherit(CartesianProductMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListProperty(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorConfigList());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.moveSelectorConfigList + ")";
    }
}

