/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.phase.custom;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.config.phase.SolverPhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhase;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhaseCommand;
import org.optaplanner.core.impl.phase.custom.DefaultCustomSolverPhase;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.termination.Termination;

@XStreamAlias(value="customSolverPhase")
public class CustomSolverPhaseConfig
extends SolverPhaseConfig {
    @XStreamImplicit(itemFieldName="customSolverPhaseCommandClass")
    protected List<Class<CustomSolverPhaseCommand>> customSolverPhaseCommandClassList = null;
    protected Boolean forceUpdateBestSolution = null;

    public List<Class<CustomSolverPhaseCommand>> getCustomSolverPhaseCommandClassList() {
        return this.customSolverPhaseCommandClassList;
    }

    public void setCustomSolverPhaseCommandClassList(List<Class<CustomSolverPhaseCommand>> customSolverPhaseCommandClassList) {
        this.customSolverPhaseCommandClassList = customSolverPhaseCommandClassList;
    }

    public Boolean getForceUpdateBestSolution() {
        return this.forceUpdateBestSolution;
    }

    public void setForceUpdateBestSolution(Boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public CustomSolverPhase buildSolverPhase(int phaseIndex, EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition, Termination solverTermination) {
        DefaultCustomSolverPhase customSolverPhase = new DefaultCustomSolverPhase();
        this.configureSolverPhase(customSolverPhase, phaseIndex, environmentMode, scoreDefinition, solverTermination);
        if (CollectionUtils.isEmpty(this.customSolverPhaseCommandClassList)) {
            throw new IllegalArgumentException("Configure at least 1 <customSolverPhaseCommandClass> in the <customSolverPhase> configuration.");
        }
        ArrayList<CustomSolverPhaseCommand> customSolverPhaseCommandList = new ArrayList<CustomSolverPhaseCommand>(this.customSolverPhaseCommandClassList.size());
        for (Class<CustomSolverPhaseCommand> customSolverPhaseCommandClass : this.customSolverPhaseCommandClassList) {
            CustomSolverPhaseCommand customSolverPhaseCommand = ConfigUtils.newInstance(this, "customSolverPhaseCommandClass", customSolverPhaseCommandClass);
            customSolverPhaseCommandList.add(customSolverPhaseCommand);
        }
        customSolverPhase.setCustomSolverPhaseCommandList(customSolverPhaseCommandList);
        customSolverPhase.setForceUpdateBestSolution(this.forceUpdateBestSolution == null ? false : this.forceUpdateBestSolution);
        return customSolverPhase;
    }

    public void inherit(CustomSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.customSolverPhaseCommandClassList = ConfigUtils.inheritMergeableListProperty(this.customSolverPhaseCommandClassList, inheritedConfig.getCustomSolverPhaseCommandClassList());
        this.forceUpdateBestSolution = ConfigUtils.inheritOverwritableProperty(this.forceUpdateBestSolution, inheritedConfig.getForceUpdateBestSolution());
    }
}

