/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.greedyFit;

import java.util.Iterator;
import org.optaplanner.core.impl.constructionheuristic.ConstructionHeuristicSolverPhase;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.GreedyFitSolverPhase;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.scope.GreedyFitSolverPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.scope.GreedyFitStepScope;
import org.optaplanner.core.impl.constructionheuristic.greedyFit.selector.GreedyPlanningEntitySelector;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultGreedyFitSolverPhase
extends AbstractSolverPhase
implements GreedyFitSolverPhase,
ConstructionHeuristicSolverPhase {
    protected GreedyPlanningEntitySelector greedyPlanningEntitySelector;
    protected GreedyDecider greedyDecider;
    protected boolean assertStepScoreFromScratch = false;
    protected boolean assertExpectedStepScore = false;

    public void setGreedyPlanningEntitySelector(GreedyPlanningEntitySelector greedyPlanningEntitySelector) {
        this.greedyPlanningEntitySelector = greedyPlanningEntitySelector;
    }

    public void setGreedyDecider(GreedyDecider greedyDecider) {
        this.greedyDecider = greedyDecider;
    }

    public void setAssertExpectedStepScore(boolean assertExpectedStepScore) {
        this.assertExpectedStepScore = assertExpectedStepScore;
    }

    public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        GreedyFitSolverPhaseScope phaseScope = new GreedyFitSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        GreedyFitStepScope stepScope = new GreedyFitStepScope(phaseScope);
        Iterator<Object> it = this.greedyPlanningEntitySelector.iterator();
        while (!this.termination.isPhaseTerminated(phaseScope) && it.hasNext()) {
            Object planningEntity = it.next();
            stepScope.setPlanningEntity(planningEntity);
            this.stepStarted(stepScope);
            this.greedyDecider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                this.logger.warn("    Cancelled step index ({}), time spend ({}): there is no doable move. Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)phaseScope.calculateSolverTimeMillisSpend());
                break;
            }
            nextStep.doMove(stepScope.getScoreDirector());
            phaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreFromScratch) {
                phaseScope.assertWorkingScoreFromScratch(stepScope.getScore(), nextStep);
            }
            if (this.assertExpectedStepScore) {
                phaseScope.assertExpectedWorkingScore(stepScope.getScore(), nextStep);
            }
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            stepScope = new GreedyFitStepScope(phaseScope);
        }
        this.phaseEnded(phaseScope);
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
    }

    public void phaseStarted(GreedyFitSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.greedyPlanningEntitySelector.phaseStarted(phaseScope);
        this.greedyDecider.phaseStarted(phaseScope);
    }

    public void stepStarted(GreedyFitStepScope stepScope) {
        super.stepStarted(stepScope);
        this.greedyPlanningEntitySelector.stepStarted(stepScope);
        this.greedyDecider.stepStarted(stepScope);
    }

    public void stepEnded(GreedyFitStepScope stepScope) {
        super.stepEnded(stepScope);
        this.greedyPlanningEntitySelector.stepEnded(stepScope);
        this.greedyDecider.stepEnded(stepScope);
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = stepScope.getPhaseScope().calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), initialized planning entity ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), stepScope.getPlanningEntity()});
        }
    }

    public void phaseEnded(GreedyFitSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        Solution newBestSolution = phaseScope.getScoreDirector().cloneWorkingSolution();
        int newBestUninitializedVariableCount = phaseScope.getSolutionDescriptor().countUninitializedVariables(newBestSolution);
        this.bestSolutionRecaller.updateBestSolution(phaseScope.getSolverScope(), newBestSolution, newBestUninitializedVariableCount);
        this.greedyPlanningEntitySelector.phaseEnded(phaseScope);
        this.greedyDecider.phaseEnded(phaseScope);
        this.logger.info("Phase ({}) constructionHeuristic ended: step total ({}), time spend ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
    }
}

