/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.impl.domain.entity.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.entity.PlanningEntitySorter;
import org.optaplanner.core.impl.heuristic.selector.entity.PlanningEntitySelectionOrder;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListenerAdapter;

@Deprecated
public class PlanningEntitySelector
extends SolverPhaseLifecycleListenerAdapter
implements Iterable<Object> {
    private PlanningEntityDescriptor planningEntityDescriptor;
    private PlanningEntitySelectionOrder selectionOrder = PlanningEntitySelectionOrder.ORIGINAL;
    private List<Object> selectedPlanningEntityList = null;

    public PlanningEntitySelector(PlanningEntityDescriptor planningEntityDescriptor) {
        this.planningEntityDescriptor = planningEntityDescriptor;
    }

    public void setSelectionOrder(PlanningEntitySelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        this.validate();
        this.initSelectedPlanningEntityList(phaseScope);
    }

    private void validate() {
        PlanningEntitySorter planningEntitySorter;
        if (this.selectionOrder == PlanningEntitySelectionOrder.DECREASING_DIFFICULTY && !(planningEntitySorter = this.planningEntityDescriptor.getPlanningEntitySorter()).isSortDifficultySupported()) {
            throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") can not be used on a PlanningEntity (" + this.planningEntityDescriptor.getPlanningEntityClass().getName() + ") that has no support for difficulty sorting. Check the @PlanningEntity annotation.");
        }
    }

    private void initSelectedPlanningEntityList(AbstractSolverPhaseScope phaseScope) {
        List<Object> workingPlanningEntityList = phaseScope.getWorkingEntityList();
        Iterator<Object> it = workingPlanningEntityList.iterator();
        while (it.hasNext()) {
            Object planningEntity = it.next();
            if (!this.planningEntityDescriptor.getPlanningEntityClass().isInstance(planningEntity)) {
                it.remove();
                continue;
            }
            if (!this.planningEntityDescriptor.isInitialized(planningEntity)) continue;
            it.remove();
        }
        switch (this.selectionOrder) {
            case ORIGINAL: {
                break;
            }
            case RANDOM: {
                Collections.shuffle(workingPlanningEntityList, phaseScope.getWorkingRandom());
                break;
            }
            case DECREASING_DIFFICULTY: {
                PlanningEntitySorter planningEntitySorter = this.planningEntityDescriptor.getPlanningEntitySorter();
                planningEntitySorter.sortDifficultyDescending(phaseScope.getWorkingSolution(), workingPlanningEntityList);
                break;
            }
            default: {
                throw new IllegalStateException("The selectionOrder (" + (Object)((Object)this.selectionOrder) + ") is not implemented.");
            }
        }
        this.selectedPlanningEntityList = workingPlanningEntityList;
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        this.selectedPlanningEntityList = null;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.selectedPlanningEntityList.iterator();
    }
}

