/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.factory;

import java.util.Iterator;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveIteratorFactory;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.phase.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class MoveIteratorFactoryToMoveSelectorBridge
extends AbstractMoveSelector {
    protected final MoveIteratorFactory moveIteratorFactory;
    protected final boolean randomSelection;
    protected ScoreDirector scoreDirector = null;

    public MoveIteratorFactoryToMoveSelectorBridge(MoveIteratorFactory moveIteratorFactory, boolean randomSelection) {
        this.moveIteratorFactory = moveIteratorFactory;
        this.randomSelection = randomSelection;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        long size = this.moveIteratorFactory.getSize(this.scoreDirector);
        if (size < 0L) {
            throw new IllegalStateException("The moveIteratorFactoryClass (" + this.moveIteratorFactory.getClass() + ") has size (" + size + ") which is negative, but a correct size is required in this Solver configuration.");
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return this.moveIteratorFactory.createOriginalMoveIterator(this.scoreDirector);
        }
        return this.moveIteratorFactory.createRandomMoveIterator(this.scoreDirector, this.workingRandom);
    }

    public String toString() {
        return "MoveIteratorFactory(" + this.moveIteratorFactory.getClass() + ")";
    }
}

