/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.PlanningVariableDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solution.Solution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<F extends AbstractScoreDirectorFactory>
implements ScoreDirector {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final F scoreDirectorFactory;
    protected boolean constraintMatchEnabledPreference = true;
    protected boolean hasChainedVariables;
    protected Map<PlanningVariableDescriptor, Map<Object, Set<Object>>> chainedVariableToTrailingEntitiesMap;
    protected Solution workingSolution;
    protected long calculateCount = 0L;

    protected AbstractScoreDirector(F scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        Collection<PlanningVariableDescriptor> chainedVariableDescriptors = this.getSolutionDescriptor().getChainedVariableDescriptors();
        this.hasChainedVariables = !chainedVariableDescriptors.isEmpty();
        this.chainedVariableToTrailingEntitiesMap = new HashMap<PlanningVariableDescriptor, Map<Object, Set<Object>>>(chainedVariableDescriptors.size());
        for (PlanningVariableDescriptor chainedVariableDescriptor : chainedVariableDescriptors) {
            this.chainedVariableToTrailingEntitiesMap.put(chainedVariableDescriptor, null);
        }
    }

    public F getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    @Override
    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public long getCalculateCount() {
        return this.calculateCount;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.resetTrailingEntityMap();
    }

    @Override
    public Solution cloneWorkingSolution() {
        return this.getSolutionDescriptor().getSolutionCloner().cloneSolution(this.workingSolution);
    }

    private void resetTrailingEntityMap() {
        if (this.hasChainedVariables) {
            List<Object> entityList = this.getSolutionDescriptor().getEntityList(this.workingSolution);
            for (Map.Entry<PlanningVariableDescriptor, Map<Object, Set<Object>>> entry : this.chainedVariableToTrailingEntitiesMap.entrySet()) {
                entry.setValue(new IdentityHashMap(entityList.size()));
            }
            for (Object entity : entityList) {
                this.insertInTrailingEntityMap(entity);
            }
        }
    }

    private void insertInTrailingEntityMap(Object entity) {
        if (this.hasChainedVariables) {
            for (Map.Entry<PlanningVariableDescriptor, Map<Object, Set<Object>>> entry : this.chainedVariableToTrailingEntitiesMap.entrySet()) {
                boolean addSucceeded;
                PlanningVariableDescriptor variableDescriptor = entry.getKey();
                if (!variableDescriptor.getPlanningEntityDescriptor().appliesToPlanningEntity(entity)) continue;
                Object value = variableDescriptor.getValue(entity);
                Map<Object, Set<Object>> valueToTrailingEntityMap = entry.getValue();
                Set<Object> trailingEntities = valueToTrailingEntityMap.get(value);
                if (trailingEntities == null) {
                    trailingEntities = Collections.newSetFromMap(new IdentityHashMap());
                    valueToTrailingEntityMap.put(value, trailingEntities);
                }
                if (addSucceeded = trailingEntities.add(entity)) continue;
                throw new IllegalStateException("The ScoreDirector (" + this.getClass() + ") is corrupted," + " because the entity (" + entity + ") for chained planningVariable (" + variableDescriptor.getVariableName() + ") cannot be inserted: it was already inserted.");
            }
        }
    }

    private void retractFromTrailingEntityMap(Object entity) {
        if (this.hasChainedVariables) {
            for (Map.Entry<PlanningVariableDescriptor, Map<Object, Set<Object>>> entry : this.chainedVariableToTrailingEntitiesMap.entrySet()) {
                boolean removeSucceeded;
                PlanningVariableDescriptor variableDescriptor = entry.getKey();
                if (!variableDescriptor.getPlanningEntityDescriptor().appliesToPlanningEntity(entity)) continue;
                Object value = variableDescriptor.getValue(entity);
                Map<Object, Set<Object>> valueToTrailingEntityMap = entry.getValue();
                Set<Object> trailingEntities = valueToTrailingEntityMap.get(value);
                boolean bl = removeSucceeded = trailingEntities != null && trailingEntities.remove(entity);
                if (!removeSucceeded) {
                    throw new IllegalStateException("The ScoreDirector (" + this.getClass() + ") is corrupted," + " because the entity (" + entity + ") for chained planningVariable (" + variableDescriptor.getVariableName() + ") cannot be retracted: it was never inserted.");
                }
                if (!trailingEntities.isEmpty()) continue;
                valueToTrailingEntityMap.put(value, null);
            }
        }
    }

    @Override
    public void beforeEntityAdded(Object entity) {
    }

    @Override
    public void afterEntityAdded(Object entity) {
        this.insertInTrailingEntityMap(entity);
    }

    @Override
    public void beforeAllVariablesChanged(Object entity) {
        this.retractFromTrailingEntityMap(entity);
    }

    @Override
    public void afterAllVariablesChanged(Object entity) {
        this.insertInTrailingEntityMap(entity);
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        this.retractFromTrailingEntityMap(entity);
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        this.insertInTrailingEntityMap(entity);
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
        this.retractFromTrailingEntityMap(entity);
    }

    @Override
    public void afterEntityRemoved(Object entity) {
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.resetTrailingEntityMap();
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        this.resetTrailingEntityMap();
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.resetTrailingEntityMap();
    }

    @Override
    public int getWorkingEntityCount() {
        return this.getSolutionDescriptor().getEntityCount(this.workingSolution);
    }

    @Override
    public List<Object> getWorkingEntityList() {
        return this.getSolutionDescriptor().getEntityList(this.workingSolution);
    }

    @Override
    public int getWorkingValueCount() {
        return this.getSolutionDescriptor().getValueCount(this.workingSolution);
    }

    @Override
    public int countWorkingSolutionUninitializedVariables() {
        return this.getSolutionDescriptor().countUninitializedVariables(this.workingSolution);
    }

    @Override
    public boolean isWorkingSolutionInitialized() {
        return this.getSolutionDescriptor().isInitialized(this.workingSolution);
    }

    protected void setCalculatedScore(Score score) {
        this.workingSolution.setScore(score);
        ++this.calculateCount;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return false;
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        if (this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("Subclass (" + this.getClass() + ") which overwrote constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") should also overwrite this method.");
        }
        throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled, this method should not be called.");
    }

    @Override
    public AbstractScoreDirector clone() {
        AbstractScoreDirector clone = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector();
        clone.setWorkingSolution(this.cloneWorkingSolution());
        return clone;
    }

    @Override
    public Object getTrailingEntity(PlanningVariableDescriptor chainedVariableDescriptor, Object planningValue) {
        Set<Object> trailingEntities = this.chainedVariableToTrailingEntitiesMap.get(chainedVariableDescriptor).get(planningValue);
        if (trailingEntities == null) {
            return null;
        }
        if (trailingEntities.size() > 1) {
            throw new IllegalStateException("The planningValue (" + planningValue + ") has multiple trailing entities (" + trailingEntities + ") pointing to it for chained planningVariable (" + chainedVariableDescriptor.getVariableName() + ").");
        }
        return trailingEntities.iterator().next();
    }

    @Override
    public void assertExpectedWorkingScore(Score expectedWorkingScore, Object completedAction) {
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("Score corruption: the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore  (" + workingScore + ") after completedAction (" + completedAction + ").");
        }
    }

    @Override
    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        ScoreDirectorFactory assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        ScoreDirector uncorruptedScoreDirector = assertionScoreDirectorFactory.buildScoreDirector();
        uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
        Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
        if (!workingScore.equals(uncorruptedScore)) {
            String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector);
            uncorruptedScoreDirector.dispose();
            throw new IllegalStateException("Score corruption: the workingScore (" + workingScore + ") is not the uncorruptedScore (" + uncorruptedScore + ") after completedAction (" + completedAction + "):\n" + scoreCorruptionAnalysis);
        }
        uncorruptedScoreDirector.dispose();
    }

    protected String buildScoreCorruptionAnalysis(ScoreDirector uncorruptedScoreDirector) {
        int count;
        if (!this.isConstraintMatchEnabled() || !uncorruptedScoreDirector.isConstraintMatchEnabled()) {
            return "  Score corruption analysis could not be generated because either corrupted constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") or uncorrupted constraintMatchEnabled (" + uncorruptedScoreDirector.isConstraintMatchEnabled() + ") is disabled.\n" + "  Check your score constraints manually.";
        }
        Collection<ConstraintMatchTotal> corruptedConstraintMatchTotals = this.getConstraintMatchTotals();
        Collection<ConstraintMatchTotal> uncorruptedConstraintMatchTotals = uncorruptedScoreDirector.getConstraintMatchTotals();
        Map<List<Object>, ConstraintMatch> corruptedMap = this.createConstraintMatchMap(corruptedConstraintMatchTotals);
        LinkedHashMap<List<Object>, ConstraintMatch> excessMap = new LinkedHashMap<List<Object>, ConstraintMatch>(corruptedMap);
        Map<List<Object>, ConstraintMatch> missingMap = this.createConstraintMatchMap(uncorruptedConstraintMatchTotals);
        excessMap.keySet().removeAll(missingMap.keySet());
        missingMap.keySet().removeAll(corruptedMap.keySet());
        int CONSTRAINT_MATCH_DISPLAY_LIMIT = 8;
        StringBuilder analysis = new StringBuilder();
        if (excessMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) which are in excess.\n");
        } else {
            analysis.append("  The corrupted scoreDirector has ").append(excessMap.size()).append(" ConstraintMatch(s) which are in excess (and should not be there):\n");
            count = 0;
            for (ConstraintMatch constraintMatch : excessMap.values()) {
                if (count >= 8) {
                    analysis.append("    ... ").append(excessMap.size() - 8).append(" more\n");
                    break;
                }
                analysis.append("    ").append(constraintMatch).append("\n");
                ++count;
            }
        }
        if (missingMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) which are missing.\n");
        } else {
            analysis.append("  The corrupted scoreDirector has ").append(missingMap.size()).append(" ConstraintMatch(s) which are missing:\n");
            count = 0;
            for (ConstraintMatch constraintMatch : missingMap.values()) {
                if (count >= 8) {
                    analysis.append("    ... ").append(missingMap.size() - 8).append(" more\n");
                    break;
                }
                analysis.append("    ").append(constraintMatch).append("\n");
                ++count;
            }
        }
        if (excessMap.isEmpty() && missingMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) in excess or missing. That could be a bug in this class (").append(this.getClass()).append(").\n");
        }
        this.appendLegacyConstraintOccurrences(analysis, this, uncorruptedScoreDirector);
        analysis.append("  Check your score constraints.");
        return analysis.toString();
    }

    @Deprecated
    protected void appendLegacyConstraintOccurrences(StringBuilder analysis, ScoreDirector corruptedScoreDirector, ScoreDirector uncorruptedScoreDirector) {
    }

    private Map<List<Object>, ConstraintMatch> createConstraintMatchMap(Collection<ConstraintMatchTotal> constraintMatchTotals) {
        LinkedHashMap<List<Object>, ConstraintMatch> constraintMatchMap = new LinkedHashMap<List<Object>, ConstraintMatch>(constraintMatchTotals.size() * 16);
        for (ConstraintMatchTotal constraintMatchTotal : constraintMatchTotals) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                ConstraintMatch previousConstraintMatch = constraintMatchMap.put(Arrays.asList(constraintMatchTotal.getConstraintPackage(), constraintMatchTotal.getConstraintName(), constraintMatchTotal.getScoreLevel(), constraintMatch.getJustificationList(), constraintMatch.getWeightAsNumber()), constraintMatch);
                if (previousConstraintMatch == null) continue;
                throw new IllegalStateException("Score corruption because the constraintMatch (" + constraintMatch + ") was added twice for constraintMatchTotal (" + constraintMatchTotal + ") without removal.");
            }
        }
        return constraintMatchMap;
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculateCount + ")";
    }
}

