/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedProperties
implements Externalizable {
    protected static transient Logger logger = LoggerFactory.getLogger(ChainedProperties.class);
    private List<Properties> props;
    private List<Properties> defaultProps;

    public ChainedProperties() {
    }

    public ChainedProperties(String confFileName, ClassLoader classLoader) {
        this(confFileName, classLoader, true);
    }

    public ChainedProperties(String confFileName, ClassLoader classLoader, boolean populateDefaults) {
        this.props = new ArrayList<Properties>();
        this.defaultProps = new ArrayList<Properties>();
        this.addProperties(System.getProperties());
        this.loadProperties(System.getProperty("drools." + confFileName), this.props);
        this.loadProperties(System.getProperty("user.home") + "/drools." + confFileName, this.props);
        this.loadProperties("drools." + confFileName, this.props);
        ClassLoader confClassLoader = classLoader;
        this.loadProperties(this.getResources("META-INF/drools." + confFileName, confClassLoader), this.props);
        this.loadProperties(this.getResources("/META-INF/drools." + confFileName, confClassLoader), this.props);
        confClassLoader = ClassLoader.getSystemClassLoader();
        if (confClassLoader != null && confClassLoader != classLoader) {
            this.loadProperties(this.getResources("META-INF/drools." + confFileName, confClassLoader), this.props);
            this.loadProperties(this.getResources("/META-INF/drools." + confFileName, confClassLoader), this.props);
        }
        if (!populateDefaults) {
            return;
        }
        confClassLoader = classLoader;
        this.loadProperties(this.getResources("META-INF/drools.default." + confFileName, confClassLoader), this.defaultProps);
        this.loadProperties(this.getResources("/META-INF/drools.default." + confFileName, confClassLoader), this.defaultProps);
        confClassLoader = ClassLoader.getSystemClassLoader();
        if (confClassLoader != null && confClassLoader != classLoader) {
            this.loadProperties(this.getResources("META-INF/drools.default." + confFileName, confClassLoader), this.defaultProps);
            this.loadProperties(this.getResources("/META-INF/drools.default." + confFileName, confClassLoader), this.defaultProps);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.props = (List)in.readObject();
        this.defaultProps = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.props);
        out.writeObject(this.defaultProps);
    }

    private Enumeration<URL> getResources(String name, ClassLoader classLoader) {
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources(name);
        }
        catch (IOException e) {
            logger.error("error", (Throwable)e);
        }
        return enumeration;
    }

    public void addProperties(Properties properties) {
        this.props.add(0, properties);
    }

    public String getProperty(String key, String defaultValue) {
        String value;
        block2: {
            Properties props;
            value = null;
            Iterator<Properties> i$ = this.props.iterator();
            while (i$.hasNext() && (value = (props = i$.next()).getProperty(key)) == null) {
            }
            if (value != null) break block2;
            i$ = this.defaultProps.iterator();
            while (i$.hasNext() && (value = (props = i$.next()).getProperty(key)) == null) {
            }
        }
        return value != null ? value : defaultValue;
    }

    public void mapStartsWith(Map<String, String> map, String startsWith, boolean includeSubProperties) {
        for (Properties props : this.props) {
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
        for (Properties props : this.defaultProps) {
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
    }

    private void mapStartsWith(Map<String, String> map, Properties properties, String startsWith, boolean includeSubProperties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(startsWith) || !includeSubProperties && key.substring(startsWith.length() + 1).indexOf(46) > 0 || map.containsKey(key)) continue;
            map.put(key, properties.getProperty(key));
        }
    }

    private void loadProperties(Enumeration<URL> enumeration, List<Properties> chain) {
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            this.loadProperties(url, chain);
        }
    }

    private void loadProperties(String fileName, List<Properties> chain) {
        File file;
        if (fileName != null && (file = new File(fileName)) != null && file.exists()) {
            try {
                this.loadProperties(file.toURL(), chain);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("file.toURL() failed for " + fileName + " properties value '" + file + "'");
            }
        }
    }

    private void loadProperties(URL confURL, List<Properties> chain) {
        if (confURL == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            InputStream is = confURL.openStream();
            properties.load(is);
            is.close();
            chain.add(properties);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

