/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SingleBenchmark;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.XmlSolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverBenchmark {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DefaultPlannerBenchmark plannerBenchmark;
    private String name = null;
    private SolverConfig solverConfig = null;
    private List<ProblemBenchmark> problemBenchmarkList = null;
    private List<SingleBenchmark> singleBenchmarkList = null;
    private int failureCount = -1;
    private Score totalScore = null;
    private Score totalWinningScoreDifference = null;
    private ScoreDifferencePercentage averageWorstScoreDifferencePercentage = null;
    private Long averageAverageCalculateCountPerSecond = null;
    private Integer ranking = null;

    public SolverBenchmark(DefaultPlannerBenchmark plannerBenchmark) {
        this.plannerBenchmark = plannerBenchmark;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public void setSolverConfig(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public List<ProblemBenchmark> getProblemBenchmarkList() {
        return this.problemBenchmarkList;
    }

    public void setProblemBenchmarkList(List<ProblemBenchmark> problemBenchmarkList) {
        this.problemBenchmarkList = problemBenchmarkList;
    }

    public List<SingleBenchmark> getSingleBenchmarkList() {
        return this.singleBenchmarkList;
    }

    public void setSingleBenchmarkList(List<SingleBenchmark> singleBenchmarkList) {
        this.singleBenchmarkList = singleBenchmarkList;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public Score getTotalScore() {
        return this.totalScore;
    }

    public Score getTotalWinningScoreDifference() {
        return this.totalWinningScoreDifference;
    }

    public ScoreDifferencePercentage getAverageWorstScoreDifferencePercentage() {
        return this.averageWorstScoreDifferencePercentage;
    }

    public Long getAverageAverageCalculateCountPerSecond() {
        return this.averageAverageCalculateCountPerSecond;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    public String getNameWithFavoriteSuffix() {
        if (this.isFavorite()) {
            return this.name + " (favorite)";
        }
        return this.name;
    }

    public void benchmarkingStarted() {
    }

    public void benchmarkingEnded() {
        this.determineTotalsAndAverages();
    }

    protected void determineTotalsAndAverages() {
        this.failureCount = 0;
        boolean firstNonFailure = true;
        this.totalScore = null;
        this.totalWinningScoreDifference = null;
        ScoreDifferencePercentage totalWorstScoreDifferencePercentage = null;
        long totalAverageCalculateCountPerSecond = 0L;
        for (SingleBenchmark singleBenchmark : this.singleBenchmarkList) {
            if (singleBenchmark.isFailure()) {
                ++this.failureCount;
                continue;
            }
            if (firstNonFailure) {
                this.totalScore = singleBenchmark.getScore();
                this.totalWinningScoreDifference = singleBenchmark.getWinningScoreDifference();
                totalWorstScoreDifferencePercentage = singleBenchmark.getWorstScoreDifferencePercentage();
                totalAverageCalculateCountPerSecond = singleBenchmark.getAverageCalculateCountPerSecond();
                firstNonFailure = false;
                continue;
            }
            this.totalScore = this.totalScore.add(singleBenchmark.getScore());
            this.totalWinningScoreDifference = this.totalWinningScoreDifference.add(singleBenchmark.getWinningScoreDifference());
            totalWorstScoreDifferencePercentage = totalWorstScoreDifferencePercentage.add(singleBenchmark.getWorstScoreDifferencePercentage());
            totalAverageCalculateCountPerSecond += singleBenchmark.getAverageCalculateCountPerSecond().longValue();
        }
        if (!firstNonFailure) {
            int successCount = this.getSuccessCount();
            this.averageWorstScoreDifferencePercentage = totalWorstScoreDifferencePercentage.divide(successCount);
            this.averageAverageCalculateCountPerSecond = totalAverageCalculateCountPerSecond / (long)successCount;
        }
    }

    public int getSuccessCount() {
        return this.singleBenchmarkList.size() - this.failureCount;
    }

    public boolean hasAnySuccess() {
        return this.getSuccessCount() > 0;
    }

    public boolean hasAnyFailure() {
        return this.failureCount > 0;
    }

    public boolean isFavorite() {
        return this.ranking != null && this.ranking == 0;
    }

    public Score getAverageScore() {
        if (this.totalScore == null) {
            return null;
        }
        return this.totalScore.divide((double)this.getSuccessCount());
    }

    public Score getAverageWinningScoreDifference() {
        if (this.totalWinningScoreDifference == null) {
            return null;
        }
        return this.totalWinningScoreDifference.divide((double)this.getSuccessCount());
    }

    public List<Score> getScoreList() {
        ArrayList<Score> scoreList = new ArrayList<Score>(this.singleBenchmarkList.size());
        for (SingleBenchmark singleBenchmark : this.singleBenchmarkList) {
            scoreList.add(singleBenchmark.getScore());
        }
        return scoreList;
    }

    public SingleBenchmark findSingleBenchmark(ProblemBenchmark problemBenchmark) {
        for (SingleBenchmark singleBenchmark : this.singleBenchmarkList) {
            if (!problemBenchmark.equals(singleBenchmark.getProblemBenchmark())) continue;
            return singleBenchmark;
        }
        return null;
    }

    public String getSolverConfigAsHtmlEscapedXml() {
        XStream xStream = XmlSolverFactory.buildXstream();
        xStream.setMode(1001);
        String xml = xStream.toXML((Object)this.solverConfig);
        return StringEscapeUtils.escapeHtml((String)xml);
    }
}

